/*
 * Decompiled with CFR 0.152.
 */
package cn.virde.nymph.net.weather;

import cn.virde.nymph.entity.weather.RealtimeWeatherEntity;
import cn.virde.nymph.exception.LocationException;
import cn.virde.nymph.net.weather.Weather;
import java.io.IOException;

public class RealtimeWeatherBriefMaker {
    private RealtimeWeatherEntity weather;
    private StringBuffer brief = new StringBuffer();

    public RealtimeWeatherBriefMaker(RealtimeWeatherEntity weather) {
        this.weather = weather;
        this.calculation();
    }

    private void calculation() {
        switch (this.weather.getResult().getSkycon()) {
            case "RAIN": 
            case "SNOW": {
                this.brief.append("\u5f53\u524d\u6b63\u5728\u4e0b");
                this.brief.append(this.weather.getResult().getSkyconName() + "\uff0c");
                this.brief.append("\u6c14\u6e29\uff1a" + this.weather.getResult().getTemperature() + "\u5ea6\u3002");
                this.brief.append(this.weather.getResult().getWind().getDescription());
                break;
            }
            case "CLEAR_DAY": 
            case "CLEAR_NIGHT": {
                this.brief.append("\u76ee\u524d\u5929\u6c14\u6674\u6717\uff0c");
                this.brief.append("\u6c14\u6e29\uff1a" + this.weather.getResult().getTemperature() + "\u5ea6\u3002");
                this.brief.append(this.weather.getResult().getWind().getDescription());
                break;
            }
            case "CLOUDY": {
                this.brief.append("\u76ee\u524d\u662f\u9634\u5929\uff0c");
                this.brief.append("\u6c14\u6e29\uff1a" + this.weather.getResult().getTemperature() + "\u5ea6\u3002");
                this.brief.append(this.weather.getResult().getWind().getDescription());
                break;
            }
            case "FOG": {
                this.brief.append("\u5f53\u524d\u6709\u96fe\uff0c");
                this.brief.append("\u6c14\u6e29\uff1a" + this.weather.getResult().getTemperature() + "\u5ea6\u3002");
                this.brief.append(this.weather.getResult().getWind().getDescription());
                break;
            }
            case "HAZE": {
                this.brief.append("\u5f53\u524d\u662f\u96fe\u973e\u5929\u6c14\uff0c");
                this.brief.append("\u6c14\u6e29\uff1a" + this.weather.getResult().getTemperature() + "\u5ea6\u3002");
                this.brief.append(this.weather.getResult().getWind().getDescription());
                break;
            }
            case "PARTLY_CLOUDY_DAY": 
            case "PARTLY_CLOUDY_NIGHT": {
                this.brief.append("\u5f53\u524d\u662f\u591a\u4e91\u5929\u6c14\uff0c");
                this.brief.append("\u6c14\u6e29\uff1a" + this.weather.getResult().getTemperature() + "\u5ea6\u3002");
                this.brief.append(this.weather.getResult().getWind().getDescription());
                break;
            }
            case "SLEET": {
                this.brief.append("\u5f53\u524d\u6709\u51bb\u96e8");
                this.brief.append("\u6c14\u6e29\uff1a" + this.weather.getResult().getTemperature() + "\u5ea6\u3002");
                this.brief.append(this.weather.getResult().getWind().getDescription());
                break;
            }
            case "WIND": {
                this.brief.append("\u5f53\u524d\u662f\u5927\u98ce\u5929\u6c14\uff0c\u98ce\u529b\u7b49\u7ea7\uff1a");
                this.brief.append(this.weather.getResult().getWind().getDescription());
                this.brief.append("\u3002\u6c14\u6e29\uff1a" + this.weather.getResult().getTemperature() + "\u5ea6\u3002");
            }
        }
    }

    public String getBrief() {
        return this.brief.toString();
    }

    public static void main(String[] args) throws IOException, LocationException {
        String str = new RealtimeWeatherBriefMaker(new Weather("\u4e0a\u6d77\u5e02\u5357\u7fd4\u9547").getRealtimeWeather()).getBrief();
        System.out.println(str);
    }
}

