/*
 * Decompiled with CFR 0.152.
 */
package cn.virde.nymph.net.weather;

import cn.virde.nymph.entity.base.LocationEntity;
import cn.virde.nymph.entity.weather.RealtimeWeatherEntity;
import cn.virde.nymph.exception.LocationException;
import cn.virde.nymph.net.weather.RealtimeWeatherBriefMaker;
import cn.virde.nymph.net.weather.Weather;
import java.io.IOException;

public class RealtimeWeather {
    private RealtimeWeatherEntity realtimeWeather;
    private String address;

    public RealtimeWeather(String addressOrIP) throws LocationException, IOException {
        Weather weather = new Weather(addressOrIP);
        this.realtimeWeather = weather.getRealtimeWeather();
        this.address = weather.getAddress();
    }

    public RealtimeWeather(LocationEntity location) throws IOException, LocationException {
        Weather weather = new Weather(location);
        this.realtimeWeather = weather.getRealtimeWeather();
        this.address = weather.getAddress();
    }

    public RealtimeWeather(double lng, double lat) throws IOException, LocationException {
        Weather weather = new Weather(new LocationEntity(lng, lat));
        this.realtimeWeather = weather.getRealtimeWeather();
        this.address = weather.getAddress();
    }

    public String getBrief() throws IOException, LocationException {
        return this.address + new RealtimeWeatherBriefMaker(this.realtimeWeather).getBrief();
    }

    public RealtimeWeatherEntity getRealtimeWeather() {
        return this.realtimeWeather;
    }

    public void setRealtimeWeather(RealtimeWeatherEntity realtimeWeather) {
        this.realtimeWeather = realtimeWeather;
    }

    public static void main(String[] args) throws LocationException, IOException {
        String str = new RealtimeWeather(123.6181640625, 25.7998911821).getBrief();
        System.out.println(str);
    }
}

