/*
 * Decompiled with CFR 0.152.
 */
package cn.virde.nymph.net.tool;

import cn.virde.nymph.Nym;
import cn.virde.nymph.config.Config;
import cn.virde.nymph.entity.base.LocationEntity;
import cn.virde.nymph.exception.LocationException;
import cn.virde.nymph.util.Log;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;

public class Position {
    private JSONObject position;

    public Position() throws LocationException, IOException {
        this.setPosition(null);
    }

    public Position(String ip) throws LocationException, IOException {
        if (this.isValiIp(ip)) {
            this.setPosition(ip);
        } else {
            Log.info("ip:" + ip + "\u4e0d\u662f\u6709\u6548\u7684\u8bf7\u6c42\u3002\u5df2\u7ecf\u9ed8\u8ba4\u4e3a\u672c\u673aIP");
            this.setPosition(null);
        }
    }

    public String getAddress() {
        if (this.position == null) {
            return null;
        }
        return this.position.getJSONObject("content").getString("address");
    }

    public LocationEntity getLocation() {
        if (this.position == null) {
            return null;
        }
        LocationEntity location = new LocationEntity();
        location.setLat(this.position.getJSONObject("content").getJSONObject("point").getDoubleValue("y") / 100000.0);
        location.setLng(this.position.getJSONObject("content").getJSONObject("point").getDoubleValue("x") / 100000.0);
        return location;
    }

    public void setPosition(String ip) throws LocationException, IOException {
        String reqUrl = Config.position.getReqUrl(ip);
        String resp = Nym.http.get(reqUrl);
        this.position = JSON.parseObject((String)resp);
        if (this.position.getIntValue("status") != 0) {
            throw new LocationException("\u666e\u901aIP\u5b9a\u4f4d\u8fd4\u56de\u503c\u6709\u8bef, \u8bf7\u6c42\u503c\uff1a" + reqUrl + ",\u8fd4\u56de\u503c\uff1a" + resp);
        }
    }

    private boolean isValiIp(String ip) {
        boolean isVali = true;
        if (!Nym.string.isIP(ip)) {
            isVali = false;
        }
        if (ip.startsWith("192.168")) {
            isVali = false;
        }
        if (ip.startsWith("127.0")) {
            isVali = false;
        }
        return isVali;
    }
}

