/*
 * Decompiled with CFR 0.152.
 */
package cn.virde.nymph.net.tool;

import cn.virde.nymph.Nym;
import cn.virde.nymph.config.Config;
import cn.virde.nymph.entity.Geocoding.ConverseGeocodingEntity;
import cn.virde.nymph.entity.Geocoding.GeocodingEntity;
import cn.virde.nymph.entity.base.LocationEntity;
import cn.virde.nymph.exception.LocationException;
import com.alibaba.fastjson.JSON;
import java.io.IOException;

public class GeocodingTool {
    public String locationToAddress(LocationEntity location) throws LocationException, IOException {
        ConverseGeocodingEntity entity = this.getConverseGeocoding(location);
        if (entity.getStatus() == 0) {
            return entity.getResult().getFormatted_address();
        }
        throw new LocationException("\u9006\u5411\u7f16\u8bd1\u5730\u7406\u4f4d\u7f6e\u65f6\u53d1\u751f\u9519\u8bef\uff0c\u9519\u8bef\u7801\uff1a" + entity.getStatus());
    }

    public LocationEntity addressToLocation(String address) throws LocationException, IOException {
        GeocodingEntity entity = this.getGeocoding(address);
        if (entity.getStatus() == 0) {
            return entity.getResult().getLocation();
        }
        throw new LocationException("\u6839\u636e\u5730\u7406\u4f4d\u7f6e\u83b7\u53d6\u7ecf\u7eac\u5ea6\u65f6\u53d1\u751f\u9519\u8bef\uff0c\u9519\u8bef\u7801\uff1a" + entity.getStatus());
    }

    public ConverseGeocodingEntity getConverseGeocodingEntity(LocationEntity location) throws IOException {
        return this.getConverseGeocoding(location);
    }

    public GeocodingEntity getGeocodingEntity(String address) throws IOException {
        return this.getGeocoding(address);
    }

    private ConverseGeocodingEntity getConverseGeocoding(LocationEntity location) throws IOException {
        String requestUrl = this.createRequestUrl(location);
        String respStr = Nym.http.get(requestUrl);
        return (ConverseGeocodingEntity)JSON.parseObject((String)respStr, ConverseGeocodingEntity.class);
    }

    private GeocodingEntity getGeocoding(String address) throws IOException {
        String requestUrl = this.createRequestUrl(address);
        String respStr = Nym.http.get(requestUrl);
        return (GeocodingEntity)JSON.parseObject((String)respStr, GeocodingEntity.class);
    }

    private String createRequestUrl(String address) {
        return this.createRequestUrl(null, address);
    }

    private String createRequestUrl(LocationEntity location) {
        return this.createRequestUrl(location.toString(), null);
    }

    private String createRequestUrl(String location, String address) {
        StringBuffer sb = new StringBuffer();
        sb.append(Config.geocoding.url);
        sb.append("?output=" + Config.geocoding.output);
        sb.append("&ak=" + Config.geocoding.ak);
        if (location != null && !location.equals("")) {
            sb.append("&location=" + location);
        }
        if (address != null && !address.equals("")) {
            sb.append("&address=" + address);
        }
        return sb.toString();
    }
}

