/*
 * Decompiled with CFR 0.152.
 */
package cn.virde.nymph.net.http;

import cn.virde.nymph.Nym;
import cn.virde.nymph.exception.Not200Exception;
import cn.virde.nymph.net.NymHttpGetHtml;
import cn.virde.nymph.net.http.NymHttpException;
import cn.virde.nymph.net.http.NymHttpGetRequest;
import cn.virde.nymph.util.Log;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class NymHttpPostRequest
extends NymHttpGetRequest {
    public <T> T post(String url, Object params, Class<T> clazz) throws NymHttpException {
        try {
            Map<String, String> mapParams = Nym.clazz.getField(params);
            return this.post(url, mapParams, clazz);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new NymHttpException("params error, detail info:" + e.getMessage());
        }
    }

    public <T> T post(String url, Map<String, String> map, Class<T> clazz) throws NymHttpException {
        try {
            String result = this.post(url, map);
            return Nym.json.jsonToObject(result, clazz);
        }
        catch (Not200Exception | IOException e) {
            throw new NymHttpException("IO Exception, detail info:" + e.getMessage());
        }
    }

    public <T> T post(String url, String key, String value, Class<T> clazz) throws NymHttpException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(key, value);
        return this.post(url, map, clazz);
    }

    public <T> T post(Class<T> clazz, String ... args) throws NymHttpException {
        String url = args[0];
        if (args.length > 1 && args.length % 2 != 1) {
            throw new NymHttpException("a key required need a value");
        }
        if (args.length == 1) {
            return this.post(url, null, clazz);
        }
        return this.get(url, this.getParams(args), clazz);
    }

    public String post(String url, List<NameValuePair> params) throws IOException, Not200Exception {
        CloseableHttpClient httpclient = HttpClients.createDefault();
        HttpPost httpPost = new HttpPost(url);
        if (params != null) {
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(params, StandardCharsets.UTF_8));
        }
        CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpPost);
        Log.alert("\u72b6\u6001\uff1a" + response.getStatusLine() + " \u8bf7\u6c42url\uff1a" + url);
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode != 200) {
            throw new Not200Exception();
        }
        InputStream is = response.getEntity().getContent();
        String responseBody = NymHttpPostRequest.getStreamAsString(is, "UTF-8");
        HttpEntity entity2 = response.getEntity();
        EntityUtils.consume((HttpEntity)entity2);
        response.close();
        return responseBody;
    }

    public String post(String url, Map<String, String> map) throws IOException, Not200Exception {
        return this.post(url, this.mapToListParams(map));
    }

    private List<NameValuePair> mapToListParams(Map<String, String> map) {
        if (map == null || map.size() == 0) {
            return null;
        }
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        for (Map.Entry<String, String> m : map.entrySet()) {
            params.add((NameValuePair)new BasicNameValuePair(m.getKey(), m.getValue()));
        }
        return params;
    }

    public String getHtml(String url) {
        return new NymHttpGetHtml().getHtml(url);
    }

    public <T> T postRaw(String url, String key, String value, Object raw, Class<T> clazz) throws NymHttpException {
        try {
            CloseableHttpClient httpClient = HttpClientBuilder.create().build();
            HttpPost post = new HttpPost(Nym.string.makeUrlWithParams(url, key, value));
            StringEntity postingString = new StringEntity(Nym.json.objectToJsonString(raw), "utf-8");
            post.setEntity((HttpEntity)postingString);
            post.setHeader("Content-type", "application/json; charset=utf-8");
            HttpResponse response = httpClient.execute((HttpUriRequest)post);
            String content = EntityUtils.toString((HttpEntity)response.getEntity());
            return Nym.json.jsonToObject(content, clazz);
        }
        catch (IOException e) {
            throw new NymHttpException("io error\uff0cdetail info :" + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getStreamAsString(InputStream stream, String charset) throws IOException {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream, charset), 8192);
            StringWriter writer = new StringWriter();
            char[] chars = new char[8192];
            int count = 0;
            while ((count = reader.read(chars)) > 0) {
                writer.write(chars, 0, count);
            }
            String string = writer.toString();
            return string;
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }
}

