/*
 * Decompiled with CFR 0.152.
 */
package cn.virde.nymph.net.http;

import cn.virde.nymph.Nym;
import cn.virde.nymph.net.http.NymHttpException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class NymHttpGetRequest {
    private URLConnection connection;
    private BufferedReader reader;

    public String get(String url, Map<String, String> params) throws NymHttpException {
        try {
            return this.get(Nym.string.makeUrlWithParams(url, params));
        }
        catch (IOException e) {
            throw new NymHttpException("IO Exception,detail info:" + e.getMessage());
        }
    }

    public <T> T get(String url, Class<T> clazz) throws NymHttpException {
        try {
            String result = this.get(url);
            return Nym.json.jsonToObject(result, clazz);
        }
        catch (IOException e) {
            throw new NymHttpException("IO Exception,detail info:" + e.getMessage());
        }
    }

    public <T> T get(String url, Object params, Class<T> clazz) throws NymHttpException {
        try {
            String result = this.get(Nym.string.makeUrlWithParams(url, params));
            return Nym.json.jsonToObject(result, clazz);
        }
        catch (IOException e) {
            throw new NymHttpException("IO Exception,detail info:" + e.getMessage());
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new NymHttpException("parames error,detail info:" + e.getMessage());
        }
    }

    public <T> T get(String url, Map<String, String> map, Class<T> clazz) throws NymHttpException {
        String result = this.get(url, map);
        return Nym.json.jsonToObject(result, clazz);
    }

    public <T> T get(String url, String key, String value, Class<T> clazz) throws NymHttpException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(key, value);
        return this.get(url, map, clazz);
    }

    public <T> T get(Class<T> clazz, String ... args) throws NymHttpException {
        String url = args[0];
        if (args.length > 1 && args.length % 2 != 1) {
            throw new NymHttpException("a key required need a value");
        }
        if (args.length == 1) {
            return this.get(url, clazz);
        }
        return this.get(url, this.getParams(args), clazz);
    }

    protected Map<String, String> getParams(String[] args) {
        HashMap<String, String> map = new HashMap<String, String>();
        String key = null;
        for (int i = 1; i < args.length; ++i) {
            if (i % 2 == 1) {
                key = args[i];
                continue;
            }
            map.put(key, args[i]);
        }
        return map;
    }

    public String get(String str) throws IOException {
        String line;
        URL url = new URL(str);
        this.connection = url.openConnection();
        this.connection.setRequestProperty("accept", "*/*");
        this.connection.setRequestProperty("connection", "Keep-Alive");
        this.connection.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
        this.connection.connect();
        this.reader = new BufferedReader(new InputStreamReader(this.connection.getInputStream(), this.getCharset()));
        StringBuffer result = new StringBuffer();
        while ((line = this.reader.readLine()) != null) {
            result.append(line);
        }
        return result.toString();
    }

    protected String getCharset() {
        String strencoding = "utf-8";
        Map<String, List<String>> map = this.connection.getHeaderFields();
        Set<String> keys = map.keySet();
        Iterator<String> iterator = keys.iterator();
        String key = null;
        String tmp = null;
        while (iterator.hasNext()) {
            int m;
            key = iterator.next();
            tmp = map.get(key).toString().toLowerCase();
            if (key == null || !key.equals("Content-Type") || (m = tmp.indexOf("charset=")) == -1) continue;
            strencoding = tmp.substring(m + 8).replace("]", "");
            return strencoding;
        }
        return strencoding;
    }
}

