/*
 * Decompiled with CFR 0.152.
 */
package cn.virde.nymph.jwt;

import cn.virde.nymph.jwt.Jwt;
import cn.virde.nymph.util.Log;
import com.alibaba.fastjson.JSON;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.SignatureAlgorithm;
import java.security.Key;
import java.util.Date;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public class JwtUtil {
    private static String profiles = "ZheGeKeYiShiSuiBianDeZiFu";
    private static String JWT_SECRET = "ZheGeYeShi";

    public static String encode(Jwt jwt) {
        return JwtUtil.low_encode(jwt.toString());
    }

    public static String encode(String id) {
        return JwtUtil.encode(new Jwt(id));
    }

    public static Jwt decode(String jwt) throws MalformedJwtException {
        String json = JwtUtil.low_decode(jwt);
        return (Jwt)JSON.parseObject((String)json, Jwt.class);
    }

    private static String low_encode(String id) {
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.HS256;
        long nowMillis = System.currentTimeMillis();
        Date now = new Date(nowMillis);
        SecretKey key = JwtUtil.generalKey();
        JwtBuilder builder = Jwts.builder().setId(id).setIssuedAt(now).setSubject("auth").signWith(signatureAlgorithm, (Key)key);
        long ttlMillis = new Date().getTime();
        if (ttlMillis >= 0L) {
            long expMillis = nowMillis + ttlMillis;
            Date exp = new Date(expMillis);
            builder.setExpiration(exp);
        }
        return builder.compact();
    }

    private static String low_decode(String jwt) throws MalformedJwtException {
        try {
            SecretKey key = JwtUtil.generalKey();
            Claims claims = (Claims)Jwts.parser().setSigningKey((Key)key).parseClaimsJws(jwt).getBody();
            return claims.getId();
        }
        catch (MalformedJwtException e) {
            Log.error("jwt \u65e0\u6548\uff0cjwt:" + jwt, (Exception)((Object)e));
            throw e;
        }
    }

    private static SecretKey generalKey() {
        String stringKey = profiles + JWT_SECRET;
        byte[] encodedKey = Base64.decodeBase64((String)stringKey);
        SecretKeySpec key = new SecretKeySpec(encodedKey, 0, encodedKey.length, "AES");
        return key;
    }

    public static boolean isErrorFormatJwt(String jwt) {
        try {
            JwtUtil.decode(jwt);
            return false;
        }
        catch (Exception e) {
            return true;
        }
    }
}

