/*
 * Decompiled with CFR 0.152.
 */
package cn.virde.nymph.entity.weather.realtime;

import cn.virde.nymph.common.base.BaseEntity;
import cn.virde.nymph.entity.weather.realtime.PrecipitationEntity;
import cn.virde.nymph.entity.weather.realtime.PrecipitationIntensity;
import cn.virde.nymph.entity.weather.realtime.WindEntity;

public class RealtimeResultEntity
extends BaseEntity {
    private static final long serialVersionUID = -6662978563885057685L;
    private String status;
    private double temperature;
    private String skycon;
    private int pm25;
    private double cloudrate;
    private double humidity;
    private PrecipitationEntity precipitation;
    private WindEntity wind;

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public double getTemperature() {
        return this.temperature;
    }

    public void setTemperature(double temperature) {
        this.temperature = temperature;
    }

    public String getSkycon() {
        return this.skycon;
    }

    public void setSkycon(String skycon) {
        this.skycon = skycon;
    }

    public int getPm25() {
        return this.pm25;
    }

    public void setPm25(int pm25) {
        this.pm25 = pm25;
    }

    public double getCloudrate() {
        return this.cloudrate;
    }

    public void setCloudrate(double cloudrate) {
        this.cloudrate = cloudrate;
    }

    public double getHumidity() {
        return this.humidity;
    }

    public void setHumidity(double humidity) {
        this.humidity = humidity;
    }

    public PrecipitationEntity getPrecipitation() {
        return this.precipitation;
    }

    public void setPrecipitation(PrecipitationEntity precipitation) {
        this.precipitation = precipitation;
    }

    public WindEntity getWind() {
        return this.wind;
    }

    public void setWind(WindEntity wind) {
        this.wind = wind;
    }

    public RealtimeResultEntity(String status, double temperature, String skycon, int pm25, double cloudrate, double humidity, PrecipitationEntity precipitation, WindEntity wind) {
        this.status = status;
        this.temperature = temperature;
        this.skycon = skycon;
        this.pm25 = pm25;
        this.cloudrate = cloudrate;
        this.humidity = humidity;
        this.precipitation = precipitation;
        this.wind = wind;
    }

    public RealtimeResultEntity() {
    }

    public String getSkyconName() {
        switch (this.skycon) {
            case "SNOW": 
            case "RAIN": {
                return new PrecipitationIntensity(this.skycon, this.precipitation.getLocal().getIntensity()).getName();
            }
            case "CLEAR_DAY": {
                return "\u6674\u5929";
            }
            case "CLEAR_NIGHT": {
                return "\u6674\u591c";
            }
            case "CLOUDY": {
                return "\u591a\u4e91";
            }
            case "FOG": {
                return "\u5927\u96fe";
            }
            case "HAZE": {
                return "\u96fe\u973e";
            }
            case "PARTLY_CLOUDY_DAY": 
            case "PARTLY_CLOUDY_NIGHT": {
                return "\u5c40\u90e8\u591a\u4e91";
            }
            case "SLEET": {
                return "\u51bb\u96e8";
            }
            case "WIND": {
                return "\u5927\u98ce";
            }
        }
        return "";
    }
}

