/*
 * Decompiled with CFR 0.152.
 */
package cn.virde.nymph.entity.date;

import cn.virde.nymph.Nym;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class TimeInterval {
    private Date startDate;
    private Date endDate;

    public TimeInterval() {
    }

    public TimeInterval(Date startDate, Date endDate) {
        this.startDate = startDate;
        this.endDate = endDate;
    }

    public TimeInterval(long start, long end) {
        this.startDate = Nym.time.toDate(start);
        this.endDate = Nym.time.toDate(end);
    }

    public long getStart() {
        return this.startDate.getTime();
    }

    public void setStart(long start) {
        this.startDate = new Date(start);
    }

    public long getEnd() {
        return this.endDate.getTime();
    }

    public void setEnd(long end) {
        this.endDate = new Date(end);
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public long getUnixStart() {
        return this.startDate.getTime() / 1000L;
    }

    public long getUnixEnd() {
        return this.endDate.getTime() / 1000L;
    }

    public boolean isNull() {
        return this.startDate == null || this.endDate == null;
    }

    public void setIntervalByHour(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(12, cal.getActualMinimum(12));
        cal.set(13, cal.getActualMinimum(13));
        this.setStartDate(cal.getTime());
        cal.set(12, cal.getActualMaximum(12));
        cal.set(13, cal.getActualMaximum(13));
        this.setEndDate(cal.getTime());
    }

    public static TimeInterval getIntervalByHour(Date date) {
        TimeInterval timeInterval = new TimeInterval();
        timeInterval.setIntervalByHour(date);
        return timeInterval;
    }

    public void setIntervalByDay(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, cal.getActualMinimum(11));
        cal.set(12, cal.getActualMinimum(12));
        cal.set(13, cal.getActualMinimum(13));
        this.setStartDate(cal.getTime());
        cal.set(11, cal.getActualMaximum(11));
        cal.set(12, cal.getActualMaximum(12));
        cal.set(13, cal.getActualMaximum(13));
        this.setEndDate(cal.getTime());
    }

    public static TimeInterval getIntervalByDay(Date date) {
        TimeInterval timeInterval = new TimeInterval();
        timeInterval.setIntervalByDay(date);
        return timeInterval;
    }

    public void setIntervalByWeek(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(7, cal.getActualMinimum(7));
        cal.set(11, cal.getActualMinimum(11));
        cal.set(12, cal.getActualMinimum(12));
        cal.set(13, cal.getActualMinimum(13));
        this.setStartDate(cal.getTime());
        cal.set(7, cal.getMaximum(7));
        cal.set(11, cal.getActualMaximum(11));
        cal.set(12, cal.getActualMaximum(12));
        cal.set(13, cal.getActualMaximum(13));
        this.setEndDate(cal.getTime());
    }

    public static TimeInterval getIntervalByWeek(Date date) {
        TimeInterval timeInterval = new TimeInterval();
        timeInterval.setIntervalByWeek(date);
        return timeInterval;
    }

    public void setIntervalByMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(5, cal.getActualMinimum(5));
        cal.set(11, cal.getActualMinimum(11));
        cal.set(12, cal.getActualMinimum(12));
        cal.set(13, cal.getActualMinimum(13));
        this.setStartDate(cal.getTime());
        cal.set(5, cal.getActualMaximum(5));
        cal.set(11, cal.getActualMaximum(11));
        cal.set(12, cal.getActualMaximum(12));
        cal.set(13, cal.getActualMaximum(13));
        this.setEndDate(cal.getTime());
    }

    public static TimeInterval getIntervalByMonth(Date date) {
        TimeInterval timeInterval = new TimeInterval();
        timeInterval.setIntervalByMonth(date);
        return timeInterval;
    }

    public void setIntervalByYear(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(2, cal.getActualMinimum(2));
        cal.set(5, cal.getActualMinimum(5));
        cal.set(11, cal.getActualMinimum(11));
        cal.set(12, cal.getActualMinimum(12));
        cal.set(13, cal.getActualMinimum(13));
        this.setStartDate(cal.getTime());
        cal.set(2, cal.getActualMaximum(2));
        cal.set(5, cal.getActualMaximum(5));
        cal.set(11, cal.getActualMaximum(11));
        cal.set(12, cal.getActualMaximum(12));
        cal.set(13, cal.getActualMaximum(13));
        this.setEndDate(cal.getTime());
    }

    public static TimeInterval getIntervalByYear(Date date) {
        TimeInterval timeInterval = new TimeInterval();
        timeInterval.setIntervalByYear(date);
        return timeInterval;
    }

    public List<TimeInterval> getIntervalOfEveryHour() {
        Date end;
        ArrayList<TimeInterval> respList = new ArrayList<TimeInterval>();
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.startDate);
        int startMinute = cal.get(12);
        int startSecond = cal.get(13);
        if (startMinute != 0 || startSecond != 0) {
            cal.add(11, 1);
            cal.set(12, 0);
            cal.set(13, 0);
        }
        Date start = cal.getTime();
        cal.setTime(this.endDate);
        int endMinute = cal.get(12);
        int endSecond = cal.get(13);
        if (endMinute != 0 || endSecond != 0) {
            cal.set(12, 0);
            cal.set(13, 0);
            cal.add(13, -1);
        }
        if (start.after(end = cal.getTime())) {
            return respList;
        }
        while (start.before(end)) {
            TimeInterval ti = TimeInterval.getIntervalByHour(start);
            respList.add(ti);
            cal.setTime(start);
            cal.add(11, 1);
            start = cal.getTime();
        }
        return respList;
    }

    public static List<TimeInterval> getIntervalOfEveryHour(Date startDate, Date endDate) {
        return new TimeInterval(startDate, endDate).getIntervalOfEveryHour();
    }

    public List<TimeInterval> getIntervalOfEveryDay() {
        Date end;
        ArrayList<TimeInterval> respList = new ArrayList<TimeInterval>();
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.startDate);
        int startHour = cal.get(11);
        int startMinute = cal.get(12);
        int startSecond = cal.get(13);
        if (startMinute != 0 || startSecond != 0 || startHour != 0) {
            cal.add(5, 1);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
        }
        Date start = cal.getTime();
        cal.setTime(this.endDate);
        int endHour = cal.get(11);
        int endMinute = cal.get(12);
        int endSecond = cal.get(13);
        if (endMinute != 0 || endSecond != 0 || endHour != 0) {
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.add(13, -1);
        }
        if (start.after(end = cal.getTime())) {
            return respList;
        }
        while (start.before(end)) {
            TimeInterval ti = TimeInterval.getIntervalByDay(start);
            respList.add(ti);
            cal.setTime(start);
            cal.add(5, 1);
            start = cal.getTime();
        }
        return respList;
    }

    public static List<TimeInterval> getIntervalOfEveryDay(Date startDate, Date endDate) {
        return new TimeInterval(startDate, endDate).getIntervalOfEveryDay();
    }

    public List<TimeInterval> getIntervalOfEveryMonth() {
        Date end;
        ArrayList<TimeInterval> respList = new ArrayList<TimeInterval>();
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.startDate);
        int startDay = cal.get(5);
        int startHour = cal.get(11);
        int startMinute = cal.get(12);
        int startSecond = cal.get(13);
        if (startMinute != 0 || startSecond != 0 || startHour != 0 || startDay != 1) {
            cal.add(2, 1);
            cal.set(5, 1);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
        }
        Date start = cal.getTime();
        cal.setTime(this.endDate);
        int endDay = cal.get(5);
        int endHour = cal.get(11);
        int endMinute = cal.get(12);
        int endSecond = cal.get(13);
        if (endMinute != 0 || endSecond != 0 || endHour != 0 || endDay != 1) {
            cal.set(5, 1);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.add(13, -1);
        }
        if (start.after(end = cal.getTime())) {
            return respList;
        }
        while (start.before(end)) {
            TimeInterval ti = TimeInterval.getIntervalByMonth(start);
            respList.add(ti);
            cal.setTime(start);
            cal.add(2, 1);
            start = cal.getTime();
        }
        return respList;
    }

    public static List<TimeInterval> getIntervalOfEveryMonth(Date startDate, Date endDate) {
        return new TimeInterval(startDate, endDate).getIntervalOfEveryMonth();
    }

    public List<Date> getEveryDay(Boolean isContainCurr) {
        ArrayList<Date> respList = new ArrayList<Date>();
        Calendar startCal = Calendar.getInstance();
        Calendar endCal = Calendar.getInstance();
        startCal.setTime(this.startDate);
        endCal.setTime(this.endDate);
        if (isContainCurr.booleanValue()) {
            startCal.set(11, 0);
            startCal.set(12, 0);
            startCal.set(13, 0);
            endCal.set(11, 0);
            endCal.set(12, 0);
            endCal.set(13, 0);
            endCal.add(5, 1);
        } else {
            if (startCal.get(11) != 0 && startCal.get(12) != 0 && startCal.get(13) != 0) {
                startCal.set(11, 0);
                startCal.set(12, 0);
                startCal.set(13, 0);
            }
            startCal.add(5, 1);
            if (endCal.get(11) != 0 && endCal.get(12) != 0 && endCal.get(13) != 0) {
                endCal.set(11, 0);
                endCal.set(12, 0);
                endCal.set(13, 0);
            }
        }
        if (startCal.getTime().after(endCal.getTime())) {
            return respList;
        }
        while (startCal.getTime().before(endCal.getTime())) {
            respList.add(startCal.getTime());
            startCal.add(5, 1);
        }
        return respList;
    }

    public List<Date> getEveryDay() {
        return this.getEveryDay(true);
    }

    public List<Date> getEveryHour(Boolean isContainCurr) {
        ArrayList<Date> respList = new ArrayList<Date>();
        Calendar startCal = Calendar.getInstance();
        Calendar endCal = Calendar.getInstance();
        startCal.setTime(this.startDate);
        endCal.setTime(this.endDate);
        if (isContainCurr.booleanValue()) {
            startCal.set(12, 0);
            startCal.set(13, 0);
            endCal.set(12, 0);
            endCal.set(13, 0);
            endCal.add(11, 1);
        } else {
            if (startCal.get(12) != 0 && startCal.get(13) != 0) {
                startCal.set(12, 0);
                startCal.set(13, 0);
            }
            startCal.add(11, 1);
            if (endCal.get(12) != 0 && endCal.get(13) != 0) {
                endCal.set(12, 0);
                endCal.set(13, 0);
            }
        }
        if (startCal.getTime().after(endCal.getTime())) {
            return respList;
        }
        while (startCal.getTime().before(endCal.getTime())) {
            respList.add(startCal.getTime());
            startCal.add(11, 1);
        }
        return respList;
    }

    public List<Date> getEveryHour() {
        return this.getEveryHour(false);
    }

    public static TimeInterval getTodayInterval() {
        return TimeInterval.getIntervalByDay(new Date());
    }

    public String toJSONString() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("startDate", Nym.time.toString(this.getStartDate()));
        map.put("endDate", Nym.time.toString(this.getEndDate()));
        return Nym.json.objectToJsonString(map);
    }
}

