/*
 * Decompiled with CFR 0.152.
 */
package cn.virde.nymph.db.redis;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class JedisService {
    private static JedisPool jedisPool;

    public static void setConfig(JedisPoolConfig config, String host, int port, String auth, int timeout) {
        JedisService.initConfig(config, host, port, auth, timeout);
    }

    public JedisService(JedisPoolConfig config, String host, int port, String auth, int timeout) {
        JedisService.initConfig(config, host, port, auth, timeout);
    }

    private static void initConfig(JedisPoolConfig config, String host, int port, String auth, int timeout) {
        jedisPool = auth != null && !"".equals(auth) ? new JedisPool((GenericObjectPoolConfig)config, host, port, timeout, auth) : new JedisPool((GenericObjectPoolConfig)config, host, port, timeout);
    }

    public static void shutdown() {
        if (jedisPool != null) {
            jedisPool.destroy();
        }
    }

    public static Jedis getJedis() {
        return jedisPool.getResource();
    }

    public static void close(Jedis jedis) {
        if (jedis != null) {
            jedis.close();
        }
    }

    public static Map<String, String> hgetAll(String key) {
        Jedis jedis = null;
        try {
            jedis = JedisService.getJedis();
            Map map = jedis.hgetAll(key);
            return map;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            JedisService.close(jedis);
        }
    }

    public static String set(String key, String value) {
        Jedis jedis = null;
        try {
            jedis = JedisService.getJedis();
            String string = jedis.set(key, value);
            return string;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            JedisService.close(jedis);
        }
    }

    public static String get(String key) {
        Jedis jedis = null;
        try {
            jedis = JedisService.getJedis();
            String string = jedis.get(key);
            return string;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            JedisService.close(jedis);
        }
    }

    public static long del(String key) {
        Jedis jedis = null;
        try {
            jedis = JedisService.getJedis();
            long l = jedis.del(key);
            return l;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            JedisService.close(jedis);
        }
    }

    public static String type(String key) {
        Jedis jedis = null;
        try {
            jedis = JedisService.getJedis();
            String string = jedis.type(key);
            return string;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            JedisService.close(jedis);
        }
    }

    public static boolean exists(String key) {
        Jedis jedis = null;
        try {
            jedis = JedisService.getJedis();
            boolean bl = jedis.exists(key);
            return bl;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            JedisService.close(jedis);
        }
    }

    public static Long lrem(String key, String value) {
        Jedis jedis = null;
        try {
            jedis = JedisService.getJedis();
            Long l = jedis.lrem(key, 0L, value);
            return l;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            JedisService.close(jedis);
        }
    }

    public static List<String> lrange(String key) {
        Jedis jedis = null;
        try {
            jedis = JedisService.getJedis();
            List list = jedis.lrange(key, 0L, -1L);
            return list;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            JedisService.close(jedis);
        }
    }

    public static long lpush(String key, String ... strings) {
        Jedis jedis = null;
        try {
            jedis = JedisService.getJedis();
            long l = jedis.lpush(key, strings);
            return l;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            JedisService.close(jedis);
        }
    }

    public static long rpush(String key, String ... strings) {
        Jedis jedis = null;
        try {
            jedis = JedisService.getJedis();
            long l = jedis.rpush(key, strings);
            return l;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            JedisService.close(jedis);
        }
    }

    public static String brpop(int timeout, String key) {
        Jedis jedis = null;
        try {
            jedis = JedisService.getJedis();
            List popList = jedis.brpop(timeout, key);
            if (popList != null) {
                String string = (String)popList.get(1);
                return string;
            }
            String string = null;
            return string;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            JedisService.close(jedis);
        }
    }

    public static String rpop(String key) {
        Jedis jedis = null;
        try {
            jedis = JedisService.getJedis();
            String string = jedis.rpop(key);
            return string;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            JedisService.close(jedis);
        }
    }

    public static String rpoplpush(String srckey, String dstkey) {
        Jedis jedis = null;
        try {
            jedis = JedisService.getJedis();
            String string = jedis.rpoplpush(srckey, dstkey);
            return string;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            JedisService.close(jedis);
        }
    }

    public static String rpoplpush(String key) {
        return JedisService.rpoplpush(key, key);
    }

    public static String hmset(String key, Map<String, String> hash) {
        Jedis jedis = null;
        try {
            jedis = JedisService.getJedis();
            String string = jedis.hmset(key, hash);
            return string;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            JedisService.close(jedis);
        }
    }

    public static long hset(String key, String field, String value) {
        Jedis jedis = null;
        try {
            jedis = JedisService.getJedis();
            long l = jedis.hset(key, field, value);
            return l;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            JedisService.close(jedis);
        }
    }

    public static String hget(String key, String field) {
        Jedis jedis = null;
        try {
            jedis = JedisService.getJedis();
            String string = jedis.hget(key, field);
            return string;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            JedisService.close(jedis);
        }
    }

    public static long hincrBy(String key, String field, long value) {
        Jedis jedis = null;
        try {
            jedis = JedisService.getJedis();
            long l = jedis.hincrBy(key, field, value);
            return l;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            JedisService.close(jedis);
        }
    }

    public static long publish(String channel, String message) {
        Jedis jedis = null;
        try {
            jedis = JedisService.getJedis();
            long l = jedis.publish(channel, message);
            return l;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            JedisService.close(jedis);
        }
    }

    public static long sadd(String key, String ... members) {
        Jedis jedis = null;
        try {
            jedis = JedisService.getJedis();
            long l = jedis.sadd(key, members);
            return l;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            JedisService.close(jedis);
        }
    }

    public static String spop(String key) {
        Jedis jedis = null;
        try {
            jedis = JedisService.getJedis();
            String string = jedis.spop(key);
            return string;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            JedisService.close(jedis);
        }
    }

    public static long srem(String key, String ... members) {
        Jedis jedis = null;
        try {
            jedis = JedisService.getJedis();
            long l = jedis.srem(key, members);
            return l;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            JedisService.close(jedis);
        }
    }

    public static long expire(String key, int seconds) {
        Jedis jedis = null;
        try {
            jedis = JedisService.getJedis();
            long l = jedis.expire(key, seconds);
            return l;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            JedisService.close(jedis);
        }
    }

    public static double hincrByFloat(String key, String field, Double value) {
        Jedis jedis = null;
        try {
            jedis = JedisService.getJedis();
            double d = jedis.hincrByFloat(key, field, value.doubleValue());
            return d;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            JedisService.close(jedis);
        }
    }

    public static List<String> lrange(String key, int start, int end) {
        Jedis jedis = null;
        try {
            jedis = JedisService.getJedis();
            List list = jedis.lrange(key, (long)start, (long)end);
            return list;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            JedisService.close(jedis);
        }
    }

    public static Set<String> smembers(String key) {
        Jedis jedis = null;
        try {
            jedis = JedisService.getJedis();
            Set set = jedis.smembers(key);
            return set;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            JedisService.close(jedis);
        }
    }

    public static long hdel(String key, String ... fields) {
        Jedis jedis = null;
        try {
            jedis = JedisService.getJedis();
            long l = jedis.hdel(key, fields);
            return l;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            JedisService.close(jedis);
        }
    }

    public static Set<String> keys(String pattern) {
        Jedis jedis = null;
        try {
            jedis = JedisService.getJedis();
            Set set = jedis.keys(pattern);
            return set;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            JedisService.close(jedis);
        }
    }

    public static String flushAll() {
        Jedis jedis = null;
        try {
            jedis = JedisService.getJedis();
            String string = jedis.flushAll();
            return string;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            JedisService.close(jedis);
        }
    }

    public static long dbSize() {
        Jedis jedis = null;
        try {
            jedis = JedisService.getJedis();
            long l = jedis.dbSize();
            return l;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            JedisService.close(jedis);
        }
    }

    public static long llen(String key) {
        Jedis jedis = null;
        try {
            jedis = JedisService.getJedis();
            long l = jedis.llen(key);
            return l;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            JedisService.close(jedis);
        }
    }

    public static boolean sismember(String key, String member) {
        Jedis jedis = null;
        try {
            jedis = JedisService.getJedis();
            boolean bl = jedis.sismember(key, member);
            return bl;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            JedisService.close(jedis);
        }
    }
}

