/*
 * Decompiled with CFR 0.152.
 */
package cn.virde.nymph.db.mysql;

import cn.virde.nymph.common.info.ValidInfo;
import cn.virde.nymph.db.ConnInfo;
import cn.virde.nymph.db.DatabaseClient;
import cn.virde.nymph.db.exception.NymDBException;
import cn.virde.nymph.enums.common.DBStyle;
import cn.virde.nymph.util.Log;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class MySql<T>
extends DatabaseClient {
    public MySql(String ip, String dbName, String user, String pass) {
        this.info = new ConnInfo(DBStyle.MYSQL, ip, dbName, user, pass);
    }

    public MySql(ConnInfo connInfo) {
        connInfo.setStyle(DBStyle.MYSQL);
        this.info = connInfo;
    }

    public synchronized List<T> query(String sql, Object[] args, Class clazz) throws NymDBException, SQLException {
        try {
            List<T> list;
            this.openPreparedStatement(sql, args);
            this.rs = this.ppsta.executeQuery();
            List<T> list2 = list = this.createResultObjectList(clazz);
            return list2;
        }
        catch (NymDBException e) {
            throw e;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.close();
        }
    }

    private List<T> createResultObjectList(Class clazz) throws SQLException, NymDBException {
        ArrayList<Object> list = new ArrayList<Object>();
        try {
            while (this.rs.next()) {
                Object obj = this.createObj(clazz);
                list.add(obj);
            }
            return list;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException e) {
            throw new NymDBException(e);
        }
        catch (NoSuchMethodException e) {
            throw new NymDBException("\u5b9e\u4f53\u65b9\u6cd5\u6709\u95ee\u9898\uff0c\u5b9e\u4f53\u5b57\u6bb5\u9700\u8981\u6362\u4e2a\u6570\u636e\u5e93\u5b57\u6bb5\u4e00\u4e00\u5bf9\u5e94\uff0c\u7528\u5c01\u88c5\u7c7b\u578b\u4ee3\u66ff\u57fa\u672c\u7c7b\u578b", e);
        }
        catch (SQLException e) {
            throw e;
        }
    }

    private int getColumnCount(ResultSetMetaData rsmd) {
        try {
            return rsmd.getColumnCount();
        }
        catch (SQLException e) {
            Log.info("\u901a\u8fc7\u67e5\u8be2\u7ed3\u679c\u5143\u4fe1\u606f\u83b7\u53d6\u884c\u6570\u65f6\u53d1\u751f\u5f02\u5e38\uff0c\u64cd\u4f5c\u5c06\u7ee7\u7eed\u4f46\u4e0d\u4f1a\u83b7\u5f97\u4efb\u4f55\u7ed3\u679c", e);
            return -1;
        }
    }

    private Object createObj(Class clazz) throws InstantiationException, IllegalAccessException, SQLException, NoSuchMethodException, SecurityException, IllegalArgumentException, InvocationTargetException {
        ResultSetMetaData rsmd = this.rs.getMetaData();
        Object obj = clazz.newInstance();
        int columnCount = this.getColumnCount(rsmd);
        for (int i = 1; i <= columnCount; ++i) {
            String cname = rsmd.getColumnName(i);
            int ctype = rsmd.getColumnType(i);
            Field[] fields = clazz.getDeclaredFields();
            Method method = null;
            for (Field field : fields) {
                if (!cname.equalsIgnoreCase(field.getName())) continue;
                String methodName = this.createMethodName(field);
                if (ctype == 4) {
                    method = clazz.getMethod(methodName, Integer.class);
                    method.invoke(obj, this.rs.getInt(i));
                    continue;
                }
                method = clazz.getMethod(methodName, String.class);
                method.invoke(obj, this.rs.getString(i));
            }
        }
        return obj;
    }

    private String createMethodName(Field field) {
        return "set" + field.getName().substring(0, 1).toUpperCase() + field.getName().substring(1);
    }

    private void openPreparedStatement(String sql, Object[] args) throws NymDBException, SQLException {
        this.open();
        this.ppsta = this.conn.prepareStatement(sql);
        this.initPpstaParas(args);
    }

    private void initPpstaParas(Object[] args) throws SQLException {
        if (args != null && args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                this.ppsta.setObject(i + 1, args[i]);
            }
        }
    }

    public synchronized int executeSQL(String sql, Object[] args) throws NymDBException, SQLException {
        this.open();
        int count = 0;
        try {
            this.conn.setAutoCommit(false);
            this.ppsta = this.conn.prepareStatement(sql);
            this.initPpstaParas(args);
            count = this.ppsta.executeUpdate();
            this.conn.commit();
            int n = count;
            return n;
        }
        catch (SQLException e) {
            this.conn.rollback();
            throw e;
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getAllTableNames() throws NymDBException {
        this.open();
        ArrayList<String> list = new ArrayList<String>();
        DatabaseMetaData dbmd = null;
        try {
            dbmd = this.conn.getMetaData();
            this.rs = dbmd.getTables(null, null, null, new String[]{"TABLE"});
            while (this.rs.next()) {
                String puffix = this.rs.getString(2);
                String table = this.rs.getString(3);
                if (puffix == null) {
                    list.add(table);
                    continue;
                }
                list.add(this.rs.getString(2) + "." + this.rs.getString(3));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            this.close();
        }
        return list;
    }

    public ValidInfo valid() {
        ValidInfo validInfo = new ValidInfo();
        try {
            Class.forName(this.info.getDRIVER());
        }
        catch (ClassNotFoundException e) {
            validInfo.add(e.getMessage());
        }
        try {
            this.conn = DriverManager.getConnection(this.info.getURL(), this.info.getUser(), this.info.getPass());
        }
        catch (SQLException e) {
            validInfo.add(e.getMessage());
        }
        finally {
            this.close();
        }
        return validInfo;
    }
}

