/*
 * Decompiled with CFR 0.152.
 */
package cn.virde.nymph.db.mysql;

import cn.virde.nymph.db.ConnInfo;
import com.mchange.v2.c3p0.ComboPooledDataSource;
import java.beans.PropertyVetoException;
import java.sql.Connection;
import java.sql.SQLException;

public class ConnPool {
    private static boolean notInit = true;
    private static final ConnPool instance = new ConnPool();
    private static ComboPooledDataSource comboPooledDataSource;

    public static boolean notInit() {
        return notInit;
    }

    public static void init(ConnInfo connInfo) throws ClassNotFoundException, PropertyVetoException {
        comboPooledDataSource = new ComboPooledDataSource();
        comboPooledDataSource.setDriverClass(connInfo.getDRIVER());
        comboPooledDataSource.setJdbcUrl(connInfo.getURL());
        comboPooledDataSource.setUser(connInfo.getUser());
        comboPooledDataSource.setPassword(connInfo.getPass());
        comboPooledDataSource.setMaxPoolSize(20);
        comboPooledDataSource.setMinPoolSize(5);
        notInit = false;
    }

    public static synchronized Connection getConnection() {
        Connection connection = null;
        try {
            connection = comboPooledDataSource.getConnection();
            return connection;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            return connection;
        }
    }

    private ConnPool() {
    }

    public static ConnPool getInstance() {
        return instance;
    }
}

