/*
 * Decompiled with CFR 0.152.
 */
package cn.virde.nymph.db.mongo;

import cn.virde.nymph.Nym;
import cn.virde.nymph.db.ConnInfo;
import cn.virde.nymph.util.Log;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import org.bson.Document;
import org.bson.conversions.Bson;

public class MongoUtil {
    private MongoClient mongoClient;
    private ConnInfo dbInfo;

    public MongoUtil(ConnInfo dbInfo) {
        this.dbInfo = dbInfo;
        this.mongoClient = new MongoClient(new MongoClientURI(dbInfo.getURL()));
    }

    public MongoClient getMongoClient() {
        return this.mongoClient;
    }

    public MongoDatabase getDatabase(String dbName) {
        return this.mongoClient.getDatabase(dbName);
    }

    public MongoDatabase getDatabase() {
        return this.getDatabase(this.dbInfo.getDbName());
    }

    public MongoCollection<Document> getColl(String collName) {
        return this.getDatabase().getCollection(collName);
    }

    public void close() {
        if (this.mongoClient != null) {
            this.mongoClient.close();
        }
    }

    public boolean isSuccessConn() {
        Document command = new Document("buildInfo", (Object)1);
        Log.info("\u6b63\u5728\u9a8c\u8bc1MongoDB\u8fde\u63a5\u2026\u2026");
        try {
            Document doc = this.getDatabase().runCommand((Bson)command);
            Log.info("\u9a8c\u8bc1\u6210\u529f,\u6570\u636e\u5e93\u7248\u672c\uff1a" + doc.getString((Object)"version"));
            return true;
        }
        catch (Exception e) {
            Log.info("\u9a8c\u8bc1\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u5e93\u8fde\u63a5\u662f\u5426\u6b63\u786e");
            return false;
        }
    }

    public boolean isExistColl(String collName) {
        MongoIterable collNames = this.getDatabase().listCollectionNames();
        for (String collName_ : collNames) {
            if (!collName_.equalsIgnoreCase(collName)) continue;
            return true;
        }
        return false;
    }

    public void insertOne(Object obj) {
        String json = Nym.json.objectToJsonString(obj);
        Document doc = Document.parse((String)json);
        String collName = Nym.clazz.getField(obj.getClass(), "collName");
        this.getColl(collName).insertOne((Object)doc);
    }
}

