/*
 * Decompiled with CFR 0.152.
 */
package cn.virde.nymph.db;

import cn.virde.nymph.db.ConnInfo;
import cn.virde.nymph.db.exception.NymDBException;
import cn.virde.nymph.db.mysql.ConnPool;
import cn.virde.nymph.util.Log;
import java.beans.PropertyVetoException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public abstract class DatabaseClient {
    protected Connection conn;
    protected ResultSet rs;
    protected Statement sta;
    protected PreparedStatement ppsta;
    protected ConnInfo info;

    protected void open() throws NymDBException {
        try {
            if (this.conn != null && !this.conn.isClosed()) {
                return;
            }
            if (ConnPool.notInit()) {
                ConnPool.init(this.info);
            }
            this.conn = ConnPool.getConnection();
        }
        catch (ClassNotFoundException e) {
            throw new NymDBException("\u52a0\u8f7dJDBC\u65f6\u51fa\u73b0ClassNotFound\u5f02\u5e38\u3002JDBC DRIVER:" + this.info.getDRIVER());
        }
        catch (SQLException e) {
            throw new NymDBException("\u52a0\u8f7dJDBC\u65f6\u51fa\u73b0SqlException:" + e.getMessage() + "\u3002JDBC DRIVER:" + this.info.getDRIVER());
        }
        catch (PropertyVetoException e) {
            e.printStackTrace();
        }
    }

    protected boolean close() {
        try {
            this.closeSta();
            this.closeRs();
            this.closePpsta();
            this.closeConn();
        }
        catch (SQLException e) {
            Log.error("\u6570\u636e\u5e93\u5de5\u5177\u5728\u5173\u95ed\u5bf9\u8c61\u65f6\u9047\u5230\u5f02\u5e38:", e.getMessage() + " , " + e.getSQLState());
            e.printStackTrace();
        }
        return true;
    }

    private void closeSta() throws SQLException {
        if (this.sta != null) {
            this.sta.close();
            this.sta = null;
        }
    }

    private void closeRs() throws SQLException {
        if (this.rs != null) {
            this.rs.close();
            this.rs = null;
        }
    }

    private void closePpsta() throws SQLException {
        if (this.ppsta != null) {
            this.ppsta.close();
            this.ppsta = null;
        }
    }

    private void closeConn() throws SQLException {
        if (this.conn != null) {
            this.conn.close();
            this.conn = null;
        }
    }
}

