/*
 * Decompiled with CFR 0.152.
 */
package cn.virde.nymph.db;

import cn.virde.nymph.enums.common.DBStyle;

public class ConnInfo {
    private DBStyle style;
    private String ip;
    private String dbName;
    private String user;
    private String pass;
    private String DRIVER;
    private String URL;

    public DBStyle getStyle() {
        return this.style;
    }

    public ConnInfo setStyle(DBStyle style) {
        this.style = style;
        return this;
    }

    public String getIp() {
        return this.ip;
    }

    public ConnInfo setIp(String ip) {
        this.ip = ip;
        return this;
    }

    public String getDbName() {
        return this.dbName;
    }

    public ConnInfo setDbName(String dbName) {
        this.dbName = dbName;
        return this;
    }

    public String getUser() {
        return this.user;
    }

    public ConnInfo setUser(String user) {
        this.user = user;
        return this;
    }

    public String getPass() {
        return this.pass;
    }

    public ConnInfo setPass(String pass) {
        this.pass = pass;
        return this;
    }

    public String getDRIVER() {
        this.initPara();
        return this.DRIVER;
    }

    public String getURL() {
        this.initPara();
        return this.URL;
    }

    public ConnInfo() {
    }

    public ConnInfo(DBStyle style, String ip, String dbName, String user, String pass) {
        this.style = style;
        this.ip = ip;
        this.dbName = dbName;
        this.user = user;
        this.pass = pass;
    }

    private void initPara() {
        switch (this.style) {
            case SQLSERVER: {
                this.DRIVER = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
                this.URL = "jdbc:sqlserver://" + this.getDealIP(this.ip, 1433) + ";DataBaseName=" + this.dbName;
                break;
            }
            case MYSQL: {
                this.DRIVER = "com.mysql.jdbc.Driver";
                this.URL = "jdbc:mysql://" + this.getDealIP(this.ip, 3306) + "/" + this.dbName + "?useUnicode=true&characterEncoding=utf-8&useSSL=false";
                break;
            }
            case ORACLE: {
                this.DRIVER = "";
                this.URL = "";
                break;
            }
            case MONGO: {
                this.DRIVER = "";
                this.URL = this.createMongoUrl();
                break;
            }
            default: {
                System.out.println("\u5904\u7406 \u6570\u636e\u5e93\u94fe\u63a5\u53c2\u6570\u65f6\u51fa\u73b0\u5f02\u5e38");
            }
        }
    }

    private String createMongoUrl() {
        StringBuffer sb = new StringBuffer();
        sb.append("mongodb://");
        if (this.user != null && this.pass != null) {
            sb.append(this.user + ":" + this.pass + "@");
        }
        sb.append(this.getDealIP(this.ip, 27017));
        if (this.dbName != null) {
            sb.append("/" + this.dbName);
        }
        return sb.toString();
    }

    private String getDealIP(String ip, int defaultPort) {
        return ip.contains(":") ? ip : ip + ":" + defaultPort;
    }
}

