/*
 * Decompiled with CFR 0.152.
 */
package cn.virde.nymph.date;

import cn.virde.nymph.date.LunarCalendarCalculate;
import cn.virde.nymph.date.LunarDate;
import cn.virde.nymph.date.MyDate;
import cn.virde.nymph.date.Week;

class SolarDate
extends MyDate {
    private static int checkMonth(int iMonth) {
        if (iMonth > 12) {
            System.out.println("Month out of range, I think you want 12 ");
            return 12;
        }
        if (iMonth < 1) {
            System.out.println("Month out of range, I think you want 1 ");
            return 1;
        }
        return iMonth;
    }

    private static int checkDay(int iYear, int iMonth, int iDay) {
        int iMonthDays = LunarCalendarCalculate.iGetSYearMonthDays(iYear, iMonth);
        if (iDay > iMonthDays) {
            System.out.println("Day out of range, I think you want " + iMonthDays + " ");
            return iMonthDays;
        }
        if (iDay < 1) {
            System.out.println("Day out of range, I think you want 1 ");
            return 1;
        }
        return iDay;
    }

    public SolarDate(int iYear, int iMonth, int iDay) {
        super(iYear);
        this.iMonth = SolarDate.checkMonth(iMonth);
        this.iDay = SolarDate.checkDay(this.iYear, this.iMonth, iDay);
    }

    public SolarDate(int iYear, int iMonth) {
        super(iYear);
        this.iMonth = SolarDate.checkMonth(iMonth);
    }

    public SolarDate(int iYear) {
        super(iYear);
    }

    public SolarDate() {
    }

    @Override
    public String toString() {
        return "" + this.iYear + (this.iMonth > 9 ? "-" + this.iMonth : "-0" + this.iMonth) + (this.iDay > 9 ? "-" + this.iDay : "-0" + this.iDay);
    }

    public Week toWeek() {
        int iOffsetDays = 0;
        for (int i = 1901; i < this.iYear; ++i) {
            if (LunarCalendarCalculate.bIsSolarLeapYear(i)) {
                iOffsetDays += 366;
                continue;
            }
            iOffsetDays += 365;
        }
        return new Week(((iOffsetDays += LunarCalendarCalculate.iGetSNewYearOffsetDays(this.iYear, this.iMonth, this.iDay)) + 2) % 7);
    }

    public LunarDate toLunarDate() {
        int iDate = Integer.parseInt(LunarCalendarCalculate.sCalendarSolarToLundar(this.iYear, this.iMonth, this.iDay));
        int iYear = iDate / 10000;
        int iMonth = iDate % 10000 / 100;
        int iDay = iDate % 100;
        LunarDate ld = new LunarDate(iYear, iMonth, iDay);
        return ld;
    }
}

