/*
 * Decompiled with CFR 0.152.
 */
package cn.virde.nymph.date;

import cn.virde.nymph.date.CalendarUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class NymTime {
    public static final CalendarUtil cal = new CalendarUtil();
    private Date date;
    private String format = "yyyy-MM-dd HH:mm:ss";

    public NymTime() {
    }

    public NymTime(Date date, String format) {
        this.date = date;
        this.format = format;
    }

    public NymTime(Date date) {
        this.date = date;
    }

    public NymTime(String date) throws ParseException {
        this.date = this.toDate(date);
    }

    public String getString() {
        return this.toString(this.date);
    }

    public Date getDate() {
        return this.date;
    }

    public NymTime setDate(Date date) {
        this.date = date;
        return this;
    }

    public NymTime setDate(String date) throws ParseException {
        this.date = this.toDate(date);
        return this;
    }

    public String toString(Date date) {
        return this.toString(date, this.format);
    }

    public String toString(Date date, String format) {
        SimpleDateFormat this_sdf = new SimpleDateFormat(format);
        return this_sdf.format(date);
    }

    public String toString(long timestamp) {
        Date d = this.toDate(timestamp);
        return this.toString(d);
    }

    public String format(Date date, String format) {
        return this.toString(date, format);
    }

    public String format(String format) {
        return this.toString(this.date, format);
    }

    public String format() {
        return this.format(this.format);
    }

    public Date toDate(String date) throws ParseException {
        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5 HH:mm:ss");
        SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
        SimpleDateFormat sdf3 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat sdf4 = new SimpleDateFormat("yyyy-MM-dd");
        Date d = null;
        try {
            d = sdf1.parse(date);
        }
        catch (ParseException e) {
            try {
                d = sdf2.parse(date);
            }
            catch (ParseException e1) {
                try {
                    d = sdf3.parse(date);
                }
                catch (ParseException e2) {
                    try {
                        d = sdf4.parse(date);
                    }
                    catch (ParseException e3) {
                        try {
                            d = this.toDate(Long.parseLong(date));
                        }
                        catch (Exception e4) {
                            throw new ParseException("NymTime - ERROR:\u8f93\u5165\u7684\u65e5\u671f\u683c\u5f0f\u4e0d\u88ab\u652f\u6301\uff0c\u65e5\u671f\uff1a" + date, 0);
                        }
                    }
                }
            }
        }
        return d;
    }

    public Date toDate(long timestamp) {
        if (timestamp / 100000000L > 1000L) {
            return new Date(timestamp);
        }
        return new Date(timestamp * 1000L);
    }

    public Date toDate(String date, SimpleDateFormat format) {
        try {
            return format.parse(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Date toDate(String date, String format) {
        SimpleDateFormat this_sdf = new SimpleDateFormat(format);
        return this.toDate(date, this_sdf);
    }

    public long toTimestamp(Date date) {
        return date.getTime() / 1000L;
    }

    public long toTimestamp() {
        return this.date.getTime() / 1000L;
    }

    public Date addTime(Date date, int UNIT, int add) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(UNIT, add);
        return cal.getTime();
    }

    public NymTime addTime(int unit, int add) {
        this.date = this.addTime(this.date, unit, add);
        return this;
    }

    public Date setTimeGetDate(Date date, int hour, int minute, int second) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(10, hour);
        cal.set(12, minute);
        cal.set(13, second);
        return cal.getTime();
    }

    public NymTime setTimeGetDate(int hour, int minute, int second) {
        this.date = this.setTimeGetDate(this.date, hour, minute, second);
        return this;
    }

    public Date timeToZero(Date date) {
        return this.setTimeGetDate(date, 0, 0, 0);
    }

    public NymTime timeToZero() {
        this.date = this.timeToZero(this.date);
        return this;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }
}

