/*
 * Decompiled with CFR 0.152.
 */
package cn.virde.nymph.date;

import cn.virde.nymph.date.ChineseEra;
import cn.virde.nymph.date.CnWeek;
import cn.virde.nymph.date.LunarCalendarCalculate;
import cn.virde.nymph.date.MyDate;
import cn.virde.nymph.date.SolarDate;

class LunarDate
extends MyDate {
    private String[] sChineseNum = new String[]{"\u96f6", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d", "\u5341"};

    private static int checkMonth(int iYear, int iMonth) {
        if (iMonth > 12 && iMonth == LunarCalendarCalculate.iGetLLeapMonth(iYear) + 12) {
            return iMonth;
        }
        if (iMonth > 12) {
            System.out.println("Month out of range, I think you want 12 ");
            return 12;
        }
        if (iMonth < 1) {
            System.out.println("Month out of range, I think you want 1 ");
            return 1;
        }
        return iMonth;
    }

    private static int checkDay(int iYear, int iMonth, int iDay) {
        int iMonthDays = LunarCalendarCalculate.iGetLMonthDays(iYear, iMonth);
        if (iDay > iMonthDays) {
            System.out.println("Day out of range, I think you want " + iMonthDays + " ");
            return iMonthDays;
        }
        if (iDay < 1) {
            System.out.println("Day out of range, I think you want 1 ");
            return 1;
        }
        return iDay;
    }

    public LunarDate(int iYear, int iMonth, int iDay) {
        super(iYear);
        this.iMonth = LunarDate.checkMonth(this.iYear, iMonth);
        this.iDay = LunarDate.checkDay(this.iYear, this.iMonth, iDay);
    }

    public LunarDate(int iYear, int iMonth) {
        super(iYear);
        this.iMonth = LunarDate.checkMonth(this.iYear, iMonth);
    }

    public LunarDate(int iYear) {
        super(iYear);
    }

    public LunarDate() {
    }

    @Override
    public String toString() {
        String sCalendar = "\u519c\u5386";
        sCalendar = sCalendar + this.sChineseNum[this.iYear / 1000] + this.sChineseNum[this.iYear % 1000 / 100] + this.sChineseNum[this.iYear % 100 / 10] + this.sChineseNum[this.iYear % 10] + "(" + this.toChineseEra() + ")\u5e74";
        if (this.iMonth > 12) {
            this.iMonth -= 12;
            sCalendar = sCalendar + "\u95f0";
        }
        sCalendar = this.iMonth == 12 ? sCalendar + "\u814a\u6708" : (this.iMonth == 11 ? sCalendar + "\u51ac\u6708" : (this.iMonth == 1 ? sCalendar + "\u6b63\u6708" : sCalendar + this.sChineseNum[this.iMonth] + "\u6708"));
        sCalendar = this.iDay > 29 ? sCalendar + "\u4e09\u5341" : (this.iDay > 20 ? sCalendar + "\u4e8c\u5341" + this.sChineseNum[this.iDay % 20] : (this.iDay == 20 ? sCalendar + "\u4e8c\u5341" : (this.iDay > 10 ? sCalendar + "\u5341" + this.sChineseNum[this.iDay % 10] : sCalendar + "\u521d" + this.sChineseNum[this.iDay])));
        return sCalendar;
    }

    public CnWeek toWeek() {
        int iOffsetDays = 0;
        for (int i = 1901; i < this.iYear; ++i) {
            iOffsetDays += LunarCalendarCalculate.iGetLYearDays(i);
        }
        return new CnWeek(((iOffsetDays += LunarCalendarCalculate.iGetLNewYearOffsetDays(this.iYear, this.iMonth, this.iDay)) + 2) % 7);
    }

    public ChineseEra toChineseEra() {
        return new ChineseEra(this.iYear);
    }

    public SolarDate toSolarDate() {
        int iDate = Integer.parseInt(LunarCalendarCalculate.sCalendarLundarToSolar(this.iYear, this.iMonth, this.iDay));
        int iYear = iDate / 10000;
        int iMonth = iDate % 10000 / 100;
        int iDay = iDate % 100;
        SolarDate sd = new SolarDate(iYear, iMonth, iDay);
        return sd;
    }
}

