/*
 * Decompiled with CFR 0.152.
 */
package cn.virde.nymph.date;

public class LunarCalendarCalculate {
    private static final int[] iLunarMonthDaysTable = new int[]{19168, 42352, 21096, 53856, 55632, 27304, 22176, 39632, 19176, 19168, 42200, 42192, 53840, 54600, 46416, 22176, 38608, 38320, 18872, 18864, 42160, 45656, 27216, 27968, 44456, 11104, 38256, 18808, 18800, 25776, 54432, 59984, 27976, 23248, 11104, 37744, 37600, 51560, 51536, 54432, 55888, 46416, 22176, 43736, 9680, 37584, 51544, 43344, 46248, 27808, 46416, 21928, 19872, 42416, 21176, 21168, 43344, 59728, 27296, 44368, 43856, 19296, 42352, 42352, 21088, 59696, 55632, 23208, 22176, 38608, 19176, 19152, 42192, 53864, 53840, 54568, 46400, 46752, 38608, 38320, 18864, 42168, 42160, 45656, 27216, 27968, 44448, 43872, 37744, 18808, 18800, 25776, 27216, 59984, 27432, 23232, 43872, 37736, 37600, 51552, 54440, 54432, 55888, 23208, 22176, 43736, 9680, 37584, 51544, 43344, 46240, 46416, 46416, 21928, 19360, 42416, 21176, 21168, 43312, 29864, 27296, 44368, 19880, 19296, 38256, 42208, 53856, 59696, 54576, 23200, 27472, 38608, 19176, 19152, 42192, 53848, 53840, 54560, 55968, 46496, 22224, 19160, 18864, 42168, 42160, 43600, 46376, 27936, 44448, 21936};
    private static final char[] iLunarLeapMonthTable = new char[]{'\u0000', 'P', '\u0004', '\u0000', ' ', '`', '\u0005', '\u0000', ' ', 'p', '\u0005', '\u0000', '@', '\u0002', '\u0006', '\u0000', 'P', '\u0003', '\u0007', '\u0000', '`', '\u0004', '\u0000', ' ', 'p', '\u0005', '\u0000', '0', '\u0080', '\u0006', '\u0000', '@', '\u0003', '\u0007', '\u0000', 'P', '\u0004', '\b', '\u0000', '`', '\u0004', '\n', '\u0000', '`', '\u0005', '\u0000', '0', '\u0080', '\u0005', '\u0000', '@', '\u0002', '\u0007', '\u0000', 'P', '\u0004', '\t', '\u0000', '`', '\u0004', '\u0000', ' ', '`', '\u0005', '\u0000', '0', '\u00b0', '\u0006', '\u0000', 'P', '\u0002', '\u0007', '\u0000', 'P', '\u0003'};
    private static final char[] iSolarLunarOffsetTable = new char[]{'1', '&', '\u001c', '.', '\"', '\u0018', '+', ' ', '\u0015', '(', '\u001d', '0', '$', '\u0019', ',', '\"', '\u0016', ')', '\u001f', '2', '&', '\u001b', '.', '#', '\u0017', '+', ' ', '\u0016', '(', '\u001d', '/', '$', '\u0019', ',', '\"', '\u0017', ')', '\u001e', '1', '&', '\u001a', '-', '#', '\u0018', '+', ' ', '\u0015', '(', '\u001c', '/', '$', '\u001a', ',', '!', '\u0017', '*', '\u001e', '0', '&', '\u001b', '-', '#', '\u0018', '+', ' ', '\u0014', '\'', '\u001d', '/', '$', '\u001a', '-', '!', '\u0016', ')', '\u001e', '0', '%', '\u001b', '.', '#', '\u0018', '+', ' ', '2', '\'', '\u001c', '/', '$', '\u001a', '-', '\"', '\u0016', '(', '\u001e', '1', '%', '\u001b', '.', '#', '\u0017', '*', '\u001f', '\u0015', '\'', '\u001c', '0', '%', '\u0019', ',', '!', '\u0017', ')', '\u001f', '2', '\'', '\u001c', '/', '#', '\u0018', '*', '\u001e', '\u0015', '(', '\u001c', '/', '$', '\u0019', '+', '!', '\u0016', ')', '\u001e', '1', '%', '\u001a', ',', '!', '\u0017', '*', '\u001f', '\u0015', '(', '\u001d', '/', '$', '\u0019', ',', ' ', '\u0016'};

    static boolean bIsSolarLeapYear(int iYear) {
        return iYear % 4 == 0 && iYear % 100 != 0 || iYear % 400 == 0;
    }

    static int iGetSYearMonthDays(int iYear, int iMonth) {
        if (iMonth == 1 || iMonth == 3 || iMonth == 5 || iMonth == 7 || iMonth == 8 || iMonth == 10 || iMonth == 12) {
            return 31;
        }
        if (iMonth == 4 || iMonth == 6 || iMonth == 9 || iMonth == 11) {
            return 30;
        }
        if (iMonth == 2) {
            if (LunarCalendarCalculate.bIsSolarLeapYear(iYear)) {
                return 29;
            }
            return 28;
        }
        return 0;
    }

    static int iGetSNewYearOffsetDays(int iYear, int iMonth, int iDay) {
        int iOffsetDays = 0;
        for (int i = 1; i < iMonth; ++i) {
            iOffsetDays += LunarCalendarCalculate.iGetSYearMonthDays(iYear, i);
        }
        return iOffsetDays += iDay - 1;
    }

    static int iGetLLeapMonth(int iYear) {
        char iMonth = iLunarLeapMonthTable[(iYear - 1901) / 2];
        if (iYear % 2 == 0) {
            return iMonth & 0xF;
        }
        return (iMonth & 0xF0) >> 4;
    }

    static int iGetLMonthDays(int iYear, int iMonth) {
        int iLeapMonth = LunarCalendarCalculate.iGetLLeapMonth(iYear);
        if (iMonth > 12 && iMonth - 12 != iLeapMonth || iMonth < 0) {
            System.out.println("Wrong month, ^_^ , i think you are want a -1, go to death!");
            return -1;
        }
        if (iMonth - 12 == iLeapMonth) {
            if ((iLunarMonthDaysTable[iYear - 1901] & 32768 >> iLeapMonth) == 0) {
                return 29;
            }
            return 30;
        }
        if (iLeapMonth > 0 && iMonth > iLeapMonth) {
            ++iMonth;
        }
        if ((iLunarMonthDaysTable[iYear - 1901] & 32768 >> iMonth - 1) == 0) {
            return 29;
        }
        return 30;
    }

    static int iGetLYearDays(int iYear) {
        int iYearDays = 0;
        int iLeapMonth = LunarCalendarCalculate.iGetLLeapMonth(iYear);
        for (int i = 1; i < 13; ++i) {
            iYearDays += LunarCalendarCalculate.iGetLMonthDays(iYear, i);
        }
        if (iLeapMonth > 0) {
            iYearDays += LunarCalendarCalculate.iGetLMonthDays(iYear, iLeapMonth + 12);
        }
        return iYearDays;
    }

    static int iGetLNewYearOffsetDays(int iYear, int iMonth, int iDay) {
        int iOffsetDays = 0;
        int iLeapMonth = LunarCalendarCalculate.iGetLLeapMonth(iYear);
        if (iLeapMonth > 0 && iLeapMonth == iMonth - 12) {
            iMonth = iLeapMonth;
            iOffsetDays += LunarCalendarCalculate.iGetLMonthDays(iYear, iMonth);
        }
        for (int i = 1; i < iMonth; ++i) {
            iOffsetDays += LunarCalendarCalculate.iGetLMonthDays(iYear, i);
            if (i != iLeapMonth) continue;
            iOffsetDays += LunarCalendarCalculate.iGetLMonthDays(iYear, iLeapMonth + 12);
        }
        return iOffsetDays += iDay - 1;
    }

    static String sCalendarSolarToLundar(int iYear, int iMonth, int iDay) {
        int iLMonth;
        int iLDay;
        int iLYear;
        int iOffsetDays = LunarCalendarCalculate.iGetSNewYearOffsetDays(iYear, iMonth, iDay);
        int iLeapMonth = LunarCalendarCalculate.iGetLLeapMonth(iYear);
        if (iOffsetDays < iSolarLunarOffsetTable[iYear - 1901]) {
            iLYear = iYear - 1;
            iLDay = iOffsetDays = iSolarLunarOffsetTable[iYear - 1901] - iOffsetDays;
            iLMonth = 12;
            while (iOffsetDays > LunarCalendarCalculate.iGetLMonthDays(iLYear, iLMonth)) {
                iLDay = iOffsetDays;
                iOffsetDays -= LunarCalendarCalculate.iGetLMonthDays(iLYear, iLMonth);
                --iLMonth;
            }
            iLDay = 0 == iLDay ? 1 : LunarCalendarCalculate.iGetLMonthDays(iLYear, iLMonth) - iOffsetDays + 1;
        } else {
            iLYear = iYear;
            iLDay = (iOffsetDays -= iSolarLunarOffsetTable[iYear - 1901]) + 1;
            iLMonth = 1;
            while (iOffsetDays >= 0) {
                iLDay = iOffsetDays + 1;
                if (iLeapMonth == iLMonth && (iOffsetDays -= LunarCalendarCalculate.iGetLMonthDays(iLYear, iLMonth)) > 0) {
                    iLDay = iOffsetDays;
                    if ((iOffsetDays -= LunarCalendarCalculate.iGetLMonthDays(iLYear, iLMonth + 12)) <= 0) {
                        iLMonth += 13;
                        break;
                    }
                }
                ++iLMonth;
            }
            --iLMonth;
        }
        return "" + iLYear + (iLMonth > 9 ? "" + iLMonth : "0" + iLMonth) + (iLDay > 9 ? "" + iLDay : "0" + iLDay);
    }

    public static String sCalendarLundarToSolar(int iYear, int iMonth, int iDay) {
        int iSYear;
        int iYearDays;
        int iOffsetDays = LunarCalendarCalculate.iGetLNewYearOffsetDays(iYear, iMonth, iDay) + iSolarLunarOffsetTable[iYear - 1901];
        int n = iYearDays = LunarCalendarCalculate.bIsSolarLeapYear(iYear) ? 366 : 365;
        if (iOffsetDays >= iYearDays) {
            iSYear = iYear + 1;
            iOffsetDays -= iYearDays;
        } else {
            iSYear = iYear;
        }
        int iSDay = iOffsetDays + 1;
        int iSMonth = 1;
        while (iOffsetDays >= 0) {
            iSDay = iOffsetDays + 1;
            iOffsetDays -= LunarCalendarCalculate.iGetSYearMonthDays(iSYear, iSMonth);
            ++iSMonth;
        }
        return "" + iSYear + (--iSMonth > 9 ? iSMonth + "" : "0" + iSMonth) + (iSDay > 9 ? iSDay + "" : "0" + iSDay);
    }
}

