/*
 * Decompiled with CFR 0.152.
 */
package cn.virde.nymph.code;

import cn.virde.nymph.util.Log;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.StringUtils;

public class AES {
    private static final String defaultCharset = "UTF-8";
    private static final String KEY_AES = "AES";

    public static String encode(String data, String key) {
        return AES.doAES(data, key, 1);
    }

    public static String decode(String data, String key) {
        return AES.doAES(data, key, 2);
    }

    private static String doAES(String data, String key, int mode) {
        try {
            if (StringUtils.isBlank((CharSequence)data) || StringUtils.isBlank((CharSequence)key)) {
                return null;
            }
            boolean encrypt = mode == 1;
            byte[] content = encrypt ? data.getBytes(defaultCharset) : AES.parseHexStr2Byte(data);
            KeyGenerator kgen = KeyGenerator.getInstance(KEY_AES);
            kgen.init(128, new SecureRandom(key.getBytes()));
            SecretKey secretKey = kgen.generateKey();
            byte[] enCodeFormat = secretKey.getEncoded();
            SecretKeySpec keySpec = new SecretKeySpec(enCodeFormat, KEY_AES);
            Cipher cipher = Cipher.getInstance(KEY_AES);
            cipher.init(mode, keySpec);
            byte[] result = cipher.doFinal(content);
            if (encrypt) {
                return AES.parseByte2HexStr(result);
            }
            return new String(result, defaultCharset);
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.error("AES \u5bc6\u6587\u5904\u7406\u5f02\u5e38", e);
            return null;
        }
    }

    public static String parseByte2HexStr(byte[] buf) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < buf.length; ++i) {
            String hex = Integer.toHexString(buf[i] & 0xFF);
            if (hex.length() == 1) {
                hex = '0' + hex;
            }
            sb.append(hex.toUpperCase());
        }
        return sb.toString();
    }

    public static byte[] parseHexStr2Byte(String hexStr) {
        if (hexStr.length() < 1) {
            return null;
        }
        byte[] result = new byte[hexStr.length() / 2];
        for (int i = 0; i < hexStr.length() / 2; ++i) {
            int high = Integer.parseInt(hexStr.substring(i * 2, i * 2 + 1), 16);
            int low = Integer.parseInt(hexStr.substring(i * 2 + 1, i * 2 + 2), 16);
            result[i] = (byte)(high * 16 + low);
        }
        return result;
    }
}

