/*
 * Decompiled with CFR 0.152.
 */
package cn.virde.nymph.String;

import cn.virde.nymph.Nym;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringTool {
    public List<String> getStringsByReg(String str, String regEx) {
        ArrayList<String> list = new ArrayList<String>();
        Matcher m = Pattern.compile(regEx).matcher(str);
        while (m.find()) {
            list.add(m.group());
        }
        return list;
    }

    public String getStringByReg(String str, String regEx) {
        List<String> list = this.getStringsByReg(str, regEx);
        if (list == null || list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    public String replaceBlank(String str) {
        String dest = "";
        if (str != null) {
            Pattern p = Pattern.compile("\\s*|\t|\r|\n");
            Matcher m = p.matcher(str);
            dest = m.replaceAll("");
        }
        return dest;
    }

    public String getSuffix(String str) {
        if (str.contains(".") && str.lastIndexOf(".") < str.length()) {
            return str.substring(str.lastIndexOf(".") + 1, str.length());
        }
        return null;
    }

    public String getFileName(String str) {
        return str.substring(str.lastIndexOf("/") + 1, str.length());
    }

    public boolean isIP(String str) {
        if (str == null || str.length() < 7 || str.length() > 15 || "".equals(str)) {
            return false;
        }
        String rexp = "([1-9]|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])(\\.(\\d|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])){3}";
        Pattern pat = Pattern.compile(rexp);
        Matcher mat = pat.matcher(str);
        boolean ipAddress = mat.find();
        return ipAddress;
    }

    public boolean isFormat(String str, String regFormat) {
        Pattern pattern = Pattern.compile(regFormat);
        Matcher matcher = pattern.matcher(str);
        return matcher.matches();
    }

    public String getParam(String url, String name) {
        Map<String, String> map = this.getParamMap(url);
        Set<String> nameSet = map.keySet();
        for (String n : nameSet) {
            if (!n.equals(name)) continue;
            return map.get(n);
        }
        return null;
    }

    public Map<String, String> getParamMap(String pageUrl) {
        String[] paramKeyV;
        HashMap<String, String> map = new HashMap<String, String>();
        if (!pageUrl.contains("?")) {
            return map;
        }
        if ((pageUrl = pageUrl.substring(pageUrl.indexOf("?") + 1, pageUrl.length())).contains("#")) {
            pageUrl = pageUrl.substring(0, pageUrl.indexOf("#"));
        }
        for (String keyV : paramKeyV = pageUrl.split("&")) {
            if (keyV.contains("=")) {
                String[] param = keyV.split("=");
                map.put(param[0], param[1]);
                continue;
            }
            map.put(keyV, "");
        }
        return map;
    }

    public String makeUrlWithParams(String url, Map<String, String> params) {
        if (params == null || params.size() == 0) {
            return url;
        }
        StringBuffer sb = new StringBuffer();
        for (Map.Entry<String, String> m : params.entrySet()) {
            sb.append(m.getKey() + "=" + m.getValue() + "&");
        }
        return url + "?" + sb.toString().substring(0, sb.length() - 1);
    }

    public String makeUrlWithParams(String ... args) {
        if (args.length == 0) {
            return null;
        }
        if (args.length == 1) {
            return args[0];
        }
        HashMap<String, String> map = new HashMap<String, String>();
        String key = "";
        for (int i = 1; i < args.length; ++i) {
            if (i % 2 == 1) {
                key = args[i];
                continue;
            }
            map.put(key, args[i]);
        }
        return this.makeUrlWithParams(args[0], map);
    }

    public String makeUrlWithParams(String url, Object params) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return this.makeUrlWithParams(url, Nym.clazz.getField(params));
    }

    public String getHost(String url) {
        return this.getStringByReg(url, "(http|ftp|https):\\/\\/([a-zA-Z0-9]([a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9])?\\.)+[a-zA-Z]{2,6}");
    }
}

