/*
 * Decompiled with CFR 0.152.
 */
package cn.virde.nymph.String;

import cn.virde.nymph.Nym;
import java.text.DecimalFormat;
import java.util.Date;

public class NymFormat {
    public String fileLength(long length) {
        int level = 0;
        double d_length = length;
        while (d_length > 1024.0) {
            d_length /= 1024.0;
            ++level;
        }
        String fmt = "";
        switch (level) {
            case 0: {
                fmt = " B";
                break;
            }
            case 1: {
                fmt = " KB";
                break;
            }
            case 2: {
                fmt = " MB";
                break;
            }
            case 3: {
                fmt = " GB";
                break;
            }
            case 4: {
                fmt = " TB";
                break;
            }
            case 5: {
                fmt = "PB";
                break;
            }
            case 6: {
                fmt = "EB";
                break;
            }
        }
        DecimalFormat df = new DecimalFormat("#0.00");
        return df.format(d_length) + fmt;
    }

    public long fileSizeToLong(String str) {
        str = str.toUpperCase().replaceAll(" ", "");
        int index = 2;
        if (!str.contains("B")) {
            index = 1;
        }
        float n = Float.parseFloat(str.substring(0, str.length() - index));
        String unit = str.substring(str.length() - index, str.length());
        long result = 0L;
        long num = (long)(n * 1000.0f);
        switch (unit.toUpperCase()) {
            case "K": 
            case "KB": {
                result = 1024L * num;
                break;
            }
            case "M": 
            case "MB": {
                result = 0x100000L * num;
                break;
            }
            case "G": 
            case "GB": {
                result = 0x40000000L * num;
            }
        }
        return result /= 1000L;
    }

    public String getAPM(Date date) {
        return this.getAPM(Nym.time.toString(date));
    }

    public String getAPM(String time) {
        int hour = Integer.parseInt(time.substring(11, 13));
        String apm = "";
        switch (hour) {
            case 0: {
                apm = "\u5b50\u65f6";
                break;
            }
            case 1: {
                apm = "\u4e11\u65f6";
                break;
            }
            case 2: {
                apm = "\u4e11\u65f6";
                break;
            }
            case 3: {
                apm = "\u5bc5\u65f6";
                break;
            }
            case 4: {
                apm = "\u5bc5\u65f6";
                break;
            }
            case 5: {
                apm = "\u65e9\u4e0a";
                break;
            }
            case 6: {
                apm = "\u65e9\u4e0a";
                break;
            }
            case 7: {
                apm = "\u65e9\u4e0a";
                break;
            }
            case 8: {
                apm = "\u65e9\u4e0a";
                break;
            }
            case 9: {
                apm = "\u4e0a\u5348";
                break;
            }
            case 10: {
                apm = "\u4e0a\u5348";
                break;
            }
            case 11: {
                apm = "\u4e2d\u5348";
                break;
            }
            case 12: {
                apm = "\u4e2d\u5348";
                break;
            }
            case 13: {
                apm = "\u4e0b\u5348";
                break;
            }
            case 14: {
                apm = "\u4e0b\u5348";
                break;
            }
            case 15: {
                apm = "\u4e0b\u5348";
                break;
            }
            case 16: {
                apm = "\u4e0b\u5348";
                break;
            }
            case 17: {
                apm = "\u4e0b\u5348";
                break;
            }
            case 18: {
                apm = "\u4e0b\u5348";
                break;
            }
            case 19: {
                apm = "\u665a\u4e0a";
                break;
            }
            case 20: {
                apm = "\u665a\u4e0a";
                break;
            }
            case 21: {
                apm = "\u665a\u4e0a";
                break;
            }
            case 22: {
                apm = "\u665a\u4e0a";
                break;
            }
            case 23: {
                apm = "\u5b50\u65f6";
            }
        }
        return apm;
    }
}

