/*
 * Decompiled with CFR 0.152.
 */
package cn.vinsonws.tools.geoserver.connector.caller.gwc;

import cn.vinsonws.tools.geoserver.connector.caller.AbstractCaller;
import cn.vinsonws.tools.geoserver.connector.caller.CommonCaller;
import java.util.Map;

public final class MapService {

    public static final class WMTSBuilder
    extends AbstractCaller.ExecutableBuilder<TMSBuilder> {
        static final String EXTEND_API = "/wmts";

        WMTSBuilder(AbstractCaller.ExecutableBuilder<?> other, String layerName, String gridSetName, String format) {
            super(other);
            this.appendApi(EXTEND_API);
            this.parameter("layer", layerName);
            this.parameter("tilematrixset", gridSetName);
            this.parameter("Service", "WMTS");
            this.parameter("Request", "GetTile");
            this.parameter("Version", "1.0.0");
            this.parameter("Format", format);
            this.parameter("TileMatrix", gridSetName + ":{TileMatrix}");
            this.parameter("TileCol", "{TileCol}");
            this.parameter("TileRow", "{TileRow}");
        }

        public String url() {
            return ((CommonCaller)this.buildCaller()).getApiWithParameters();
        }
    }

    public static final class TMSBuilder
    extends AbstractCaller.ExecutableBuilder<TMSBuilder>
    implements AbstractCaller.Get<Map<String, Object>> {
        static final String EXTEND_API = "/tms/1.0.0";
        private final String format;

        TMSBuilder(AbstractCaller.ExecutableBuilder<?> other, String layerName, String gridSetName, String format) {
            super(other);
            this.appendApi("/tms/1.0.0/" + layerName + "@" + gridSetName + "@" + format);
            this.format = format;
        }

        public String url() {
            return this.buildGetArgs().getApi() + "/{z}/{x}/{reverseY}." + this.format;
        }
    }

    public static final class MapServiceBuilder
    extends AbstractCaller.ExecutableBuilder<MapServiceBuilder> {
        static final String EXTEND_API = "/service";

        MapServiceBuilder(AbstractCaller.ExecutableBuilder<?> other) {
            super(other);
            this.appendApi(EXTEND_API);
        }

        public TMSBuilder tms(String layerName, String gridSetName, String format) {
            return new TMSBuilder(this, layerName, gridSetName, format);
        }

        public WMTSBuilder wmts(String layerName, String gridSetName, String format) {
            return new WMTSBuilder(this, layerName, gridSetName, format);
        }
    }
}

