/*
 * Decompiled with CFR 0.152.
 */
package com.vikadata.social.qq;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.web.client.DefaultResponseErrorHandler;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.UnknownHttpStatusCodeException;

public class QQErrorHandler
extends DefaultResponseErrorHandler {
    private static final Log logger = LogFactory.getLog(QQErrorHandler.class);
    private final ObjectMapper objectMapper = new ObjectMapper();

    public QQErrorHandler() {
        this.objectMapper.setPropertyNamingStrategy(PropertyNamingStrategies.SNAKE_CASE);
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public boolean hasError(ClientHttpResponse response) throws IOException {
        int rawStatusCode = response.getRawStatusCode();
        HttpStatus statusCode = HttpStatus.resolve((int)rawStatusCode);
        if (statusCode != null) {
            if (statusCode.is2xxSuccessful()) {
                int ret;
                byte[] body = this.getResponseBody(response);
                JsonNode jsonNode = this.objectMapper.readTree(body);
                if (jsonNode.has("error")) {
                    logger.error((Object)("QQ Authorization error:" + jsonNode.get("error") + ", description: " + jsonNode.get("error_description")));
                    return true;
                }
                if (jsonNode.has("ret") && (ret = jsonNode.get("ret").asInt()) != 0) {
                    logger.error((Object)("QQ get user info error, return code: " + jsonNode.get("ret") + ", message: " + jsonNode.get("msg")));
                    return true;
                }
                return false;
            }
            return super.hasError(statusCode);
        }
        return super.hasError(rawStatusCode);
    }

    public void handleError(ClientHttpResponse response) throws IOException {
        HttpStatus statusCode;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Http Response Status: " + response.getRawStatusCode()));
        }
        if ((statusCode = HttpStatus.resolve((int)response.getRawStatusCode())) != null) {
            if (statusCode.is2xxSuccessful()) {
                int ret;
                byte[] body = this.getResponseBody(response);
                JsonNode jsonNode = this.objectMapper.readTree(body);
                if (jsonNode.has("error")) {
                    throw HttpClientErrorException.create((String)jsonNode.get("error_description").asText(), (HttpStatus)statusCode, (String)response.getStatusText(), (HttpHeaders)response.getHeaders(), (byte[])body, (Charset)this.getCharset(response));
                }
                if (jsonNode.has("ret") && (ret = jsonNode.get("ret").asInt()) != 0) {
                    throw HttpClientErrorException.create((String)jsonNode.get("msg").asText(), (HttpStatus)statusCode, (String)response.getStatusText(), (HttpHeaders)response.getHeaders(), (byte[])body, (Charset)this.getCharset(response));
                }
            } else {
                super.handleError(response, statusCode);
            }
        } else {
            byte[] body = this.getResponseBody(response);
            String message = "Connect Server Error";
            throw new UnknownHttpStatusCodeException(message, response.getRawStatusCode(), response.getStatusText(), response.getHeaders(), body, this.getCharset(response));
        }
    }
}

