/*
 * Decompiled with CFR 0.152.
 */
package com.vikadata.social.qq;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.vikadata.social.core.ApiBinding;
import com.vikadata.social.qq.AppConfig;
import com.vikadata.social.qq.AuthOperations;
import com.vikadata.social.qq.AuthTemplate;
import com.vikadata.social.qq.QQ;
import com.vikadata.social.qq.QQErrorHandler;
import java.util.Arrays;
import org.springframework.http.MediaType;
import org.springframework.http.client.BufferingClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.client.ResponseErrorHandler;

public class QQTemplate
extends ApiBinding
implements QQ {
    private AuthOperations authOperations;

    public QQTemplate(AppConfig appConfig) {
        this.configureRestTemplate();
        this.authOperations = new AuthTemplate(appConfig, this.getRestTemplate());
    }

    private void configureRestTemplate() {
        super.setRequestFactory(QQTemplate.bufferRequestWrapper(this.getRestTemplate().getRequestFactory()));
        this.getRestTemplate().getInterceptors().add(this.userAgentInterceptor());
        MappingJackson2HttpMessageConverter converter = new MappingJackson2HttpMessageConverter();
        converter.setSupportedMediaTypes(Arrays.asList(MediaType.TEXT_HTML, MediaType.TEXT_PLAIN));
        this.getRestTemplate().getMessageConverters().add(converter);
        this.getRestTemplate().setErrorHandler((ResponseErrorHandler)new QQErrorHandler());
    }

    private ClientHttpRequestInterceptor userAgentInterceptor() {
        return (request, bytes, execution) -> {
            request.getHeaders().set("User-Agent", "VIKA_QQ");
            return execution.execute(request, bytes);
        };
    }

    public void setRequestFactory(ClientHttpRequestFactory requestFactory) {
        super.setRequestFactory(QQTemplate.bufferRequestWrapper(requestFactory));
    }

    protected MappingJackson2HttpMessageConverter getJsonMessageConverter() {
        MappingJackson2HttpMessageConverter converter = super.getJsonMessageConverter();
        converter.getObjectMapper().setPropertyNamingStrategy(PropertyNamingStrategies.SNAKE_CASE);
        converter.getObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return converter;
    }

    private static ClientHttpRequestFactory bufferRequestWrapper(ClientHttpRequestFactory requestFactory) {
        return new BufferingClientHttpRequestFactory(requestFactory);
    }

    @Override
    public AuthOperations authOperations() {
        return this.authOperations;
    }
}

