/*
 * Decompiled with CFR 0.152.
 */
package com.vikadata.social.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.CharBuffer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ServletUtil.class);

    public static String getRequestBody(HttpServletRequest request) {
        try {
            return ServletUtil.getRequestBody(request.getReader());
        }
        catch (IOException e) {
            LOG.error("get servlet request error", (Throwable)e);
            return null;
        }
    }

    public static String getRequestBody(BufferedReader reader) {
        StringBuilder builder = new StringBuilder();
        CharBuffer buffer = CharBuffer.allocate(8192);
        try {
            while (-1 != reader.read(buffer)) {
                builder.append(buffer.flip());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return builder.toString();
    }

    public static void toResponseData(HttpServletResponse response, String responseText) {
        response.setContentType("application/json");
        try (PrintWriter writer = response.getWriter();){
            ((Writer)writer).write(responseText);
            ((Writer)writer).flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

