/*
 * Decompiled with CFR 0.152.
 */
package cn.vika.core.utils;

import java.util.List;
import java.util.Map;

public class StringUtil {
    public static final char SLASH_CHAR = '/';
    private static final char BACKSLASH_CHAR = '\\';
    public static final String SLASH = "/";
    public static final String EMPTY = "";
    public static final String DOT = ".";
    public static final String DOUBLE_DOT = "..";
    public static final String COLON = ":";

    public static boolean hasText(String str) {
        return str != null && !str.isEmpty() && StringUtil.containsText(str);
    }

    public static boolean hasLength(String str) {
        return str != null && !str.isEmpty();
    }

    private static boolean containsText(CharSequence str) {
        int strLen = str.length();
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static String format(String template, Map<String, ?> values) {
        if (null == template) {
            return null;
        }
        if (null == values || values.isEmpty()) {
            return template;
        }
        String template2 = template;
        for (Map.Entry<String, ?> entry : values.entrySet()) {
            String value = entry.getValue().toString();
            if (null == value) continue;
            template2 = StringUtil.replace(template2, 0, "{" + entry.getKey() + "}", value);
        }
        return template2;
    }

    public static String format(String template, Object ... params) {
        if (null == template) {
            return null;
        }
        if (params == null || params.length == 0 || StringUtil.isEmpty(template)) {
            return template;
        }
        return String.format(template, params);
    }

    public static String replace(String str, int fromIndex, String searchStr, String replacement) {
        int index;
        if (StringUtil.isEmpty(str) || StringUtil.isEmpty(searchStr)) {
            return str;
        }
        if (null == replacement) {
            replacement = EMPTY;
        }
        int strLength = str.length();
        int searchStrLength = searchStr.length();
        if (fromIndex > strLength) {
            return str;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        StringBuilder result = new StringBuilder(strLength + 16);
        if (0 != fromIndex) {
            result.append(str.subSequence(0, fromIndex));
        }
        int preIndex = fromIndex;
        while ((index = str.indexOf(searchStr, preIndex)) > -1) {
            result.append(str.subSequence(preIndex, index));
            result.append(replacement);
            preIndex = index + searchStrLength;
        }
        if (preIndex < strLength) {
            result.append(str.subSequence(preIndex, strLength));
        }
        return result.toString();
    }

    public static boolean isEmpty(CharSequence str) {
        return str == null || str.length() == 0;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static String wrap(CharSequence str, CharSequence prefix) {
        return StringUtil.nullToEmpty(prefix).concat(StringUtil.nullToEmpty(str));
    }

    public static String wrap(CharSequence str, CharSequence prefix, CharSequence suffix) {
        return StringUtil.nullToEmpty(prefix).concat(StringUtil.nullToEmpty(str)).concat(StringUtil.nullToEmpty(suffix));
    }

    public static String nullToEmpty(CharSequence str) {
        return StringUtil.nullToDefault(str, EMPTY);
    }

    public static String nullToDefault(CharSequence str, String defaultStr) {
        return str == null ? defaultStr : str.toString();
    }

    public static String getName(String filePath) {
        if (null == filePath) {
            return null;
        }
        int len = filePath.length();
        if (0 == len) {
            return filePath;
        }
        if (StringUtil.isFileSeparator(filePath.charAt(len - 1))) {
            --len;
        }
        int begin = 0;
        for (int i = len - 1; i > -1; --i) {
            char c = filePath.charAt(i);
            if (!StringUtil.isFileSeparator(c)) continue;
            begin = i + 1;
            break;
        }
        return filePath.substring(begin, len);
    }

    public static boolean isFileSeparator(char c) {
        return '/' == c || '\\' == c;
    }

    public static String removePrefix(CharSequence str, CharSequence prefix) {
        if (StringUtil.isEmpty(str) || StringUtil.isEmpty(prefix)) {
            return null == str ? null : str.toString();
        }
        String str2 = str.toString();
        if (str2.startsWith(prefix.toString())) {
            return StringUtil.sub(str2, prefix.length(), str2.length());
        }
        return str2;
    }

    public static String removePrefixIgnoreCase(CharSequence str, CharSequence prefix) {
        if (StringUtil.isEmpty(str) || StringUtil.isEmpty(prefix)) {
            return null == str ? null : str.toString();
        }
        String str2 = str.toString();
        if (str2.toLowerCase().startsWith(prefix.toString().toLowerCase())) {
            if (StringUtil.isEmpty(str2)) {
                return null;
            }
            return StringUtil.sub(str2, prefix.length(), str2.length());
        }
        return str2;
    }

    public static String sub(CharSequence str, int fromIndex, int toIndex) {
        if (StringUtil.isEmpty(str)) {
            return null == str ? null : str.toString();
        }
        int len = str.length();
        if (fromIndex < 0) {
            if ((fromIndex = len + fromIndex) < 0) {
                fromIndex = 0;
            }
        } else if (fromIndex > len) {
            fromIndex = len;
        }
        if (toIndex < 0) {
            if ((toIndex = len + toIndex) < 0) {
                toIndex = len;
            }
        } else if (toIndex > len) {
            toIndex = len;
        }
        if (toIndex < fromIndex) {
            int tmp = fromIndex;
            fromIndex = toIndex;
            toIndex = tmp;
        }
        if (fromIndex == toIndex) {
            return EMPTY;
        }
        return str.toString().substring(fromIndex, toIndex);
    }

    public static String join(List<String> list, CharSequence conjunction) {
        if (null == list) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (String s : list) {
            sb.append(conjunction);
            sb.append(s);
        }
        return sb.toString();
    }

    public static String getFilenameExtension(String fileName) {
        if (fileName == null) {
            return null;
        }
        int extIndex = fileName.lastIndexOf(DOT);
        if (extIndex == -1) {
            return null;
        }
        int folderIndex = fileName.lastIndexOf(SLASH);
        if (folderIndex > extIndex) {
            return null;
        }
        return fileName.substring(extIndex + 1);
    }
}

