/*
 * Decompiled with CFR 0.152.
 */
package cn.vika.core.utils;

import cn.vika.core.exception.JsonConvertException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;

public class JacksonConverter {
    static ObjectMapper mapper = new ObjectMapper();

    public static ObjectMapper instance() {
        return mapper;
    }

    public static JavaType getCollectionJavaType(Class<?> type) {
        return mapper.getTypeFactory().constructCollectionType(List.class, type);
    }

    public static <T> Map<String, Object> toMap(T bean) {
        return (Map)mapper.convertValue(bean, (TypeReference)new TypeReference<Map<String, Object>>(){});
    }

    public static <T> T toBean(InputStream inputStream, Type type) {
        try {
            return (T)mapper.readValue(inputStream, mapper.constructType(type));
        }
        catch (IOException e) {
            throw new JsonConvertException((Throwable)e, type);
        }
    }

    public static <T> T toGenericBean(byte[] bytes, Type type) {
        try {
            JavaType javaType = mapper.constructType(type);
            return (T)mapper.readValue(bytes, javaType);
        }
        catch (IOException e) {
            throw new JsonConvertException(e);
        }
    }

    public static <T> T toGenericBean(InputStream inputStream, Type type) {
        try {
            JavaType javaType = mapper.constructType(type);
            return (T)mapper.readValue(inputStream, javaType);
        }
        catch (IOException e) {
            throw new JsonConvertException(e);
        }
    }

    public static <T> T toGenericBean(Object object, JavaType javaType) {
        try {
            return (T)mapper.readValue(JacksonConverter.toJsonBytes(object), javaType);
        }
        catch (IOException e) {
            throw new JsonConvertException(e);
        }
    }

    public static String toJson(Object obj) {
        try {
            return mapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new JsonConvertException((Throwable)e, obj.getClass());
        }
    }

    public static byte[] toJsonBytes(Object obj) {
        return JacksonConverter.toJsonBytes(obj, StandardCharsets.UTF_8);
    }

    public static byte[] toJsonBytes(Object obj, Charset charset) {
        try {
            String jsonStr = mapper.writeValueAsString(obj);
            if (jsonStr == null) {
                return new byte[0];
            }
            return jsonStr.getBytes(charset);
        }
        catch (JsonProcessingException e) {
            throw new JsonConvertException((Throwable)e, obj.getClass());
        }
    }

    public static <T> List<T> unmarshalToList(Class<T> returnType, JsonNode root) throws IOException {
        CollectionType javaType = mapper.getTypeFactory().constructCollectionType(List.class, returnType);
        ObjectReader reader = mapper.readerFor((JavaType)javaType);
        return (List)reader.readValue(root);
    }

    public static JsonNode unmarshal(byte[] jsonString) throws IOException {
        return mapper.readTree(jsonString);
    }

    static {
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    }
}

