/*
 * Decompiled with CFR 0.152.
 */
package cn.vika.core.utils;

import cn.vika.core.utils.AssertUtil;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.stream.Collectors;

public class IoUtil {
    public static final int BUFFER_SIZE = 4096;

    public static String readString(InputStream inputStream) {
        return new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
    }

    public static byte[] copyToByteArray(InputStream in) throws IOException {
        int len;
        if (in == null) {
            return new byte[0];
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        while ((len = in.read(buffer, 0, buffer.length)) != -1) {
            baos.write(buffer, 0, len);
        }
        baos.flush();
        return baos.toByteArray();
    }

    public static byte[] readBytes(InputStream in) throws IOException {
        if (in == null) {
            return new byte[0];
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
        try {
            IoUtil.copy(in, (OutputStream)out);
        }
        finally {
            IoUtil.close(in);
            IoUtil.close(out);
        }
        return out.toByteArray();
    }

    public static int copy(InputStream in, OutputStream out) throws IOException {
        int bytesRead;
        AssertUtil.notNull(in, "No InputStream specified");
        AssertUtil.notNull(out, "No OutputStream specified");
        int byteCount = 0;
        byte[] buffer = new byte[4096];
        while ((bytesRead = in.read(buffer)) != -1) {
            out.write(buffer, 0, bytesRead);
            byteCount += bytesRead;
        }
        out.flush();
        return byteCount;
    }

    public static void copy(byte[] in, OutputStream out) throws IOException {
        AssertUtil.notNull(in, "No input byte array specified");
        AssertUtil.notNull(out, "No OutputStream specified");
        out.write(in);
        out.flush();
    }

    public static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

