/*
 * Decompiled with CFR 0.152.
 */
package cn.vika.core.http;

import cn.vika.core.http.ResourceLoader;
import cn.vika.core.utils.IoUtil;
import cn.vika.core.utils.StringUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;

public class UrlResourceLoader
implements ResourceLoader {
    private static final String URL_PROTOCOL_FILE = "file";
    private static final String URL_PROTOCOL_VFSFILE = "vfsfile";
    private static final String URL_PROTOCOL_VFS = "vfs";
    protected URL url;
    protected String name;

    public UrlResourceLoader(URL url) {
        this(url, null);
    }

    public UrlResourceLoader(URL url, String name) {
        this.url = url;
        this.name = StringUtil.hasText(name) ? name : (url != null ? StringUtil.getName(url.getPath()) : null);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public URL getUrl() {
        return this.url;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (null == this.url) {
            throw new RuntimeException("URL is null!");
        }
        return this.url.openStream();
    }

    @Override
    public byte[] readBytes() throws IOException {
        InputStream in = null;
        try {
            in = this.getInputStream();
            byte[] byArray = IoUtil.readBytes(in);
            return byArray;
        }
        finally {
            IoUtil.close(in);
        }
    }

    @Override
    public long contentLength() throws IOException {
        if (this.isFileURL(this.url)) {
            File file = this.getFile();
            long length = file.length();
            if (length == 0L && !file.exists()) {
                throw new FileNotFoundException("URL[ " + this.url + " ] cannot be resolved in the file system for checking its content length");
            }
            return length;
        }
        URLConnection con = this.url.openConnection();
        this.setConnection(con);
        return con.getContentLengthLong();
    }

    protected void setConnection(URLConnection con) throws IOException {
        con.setUseCaches(con.getClass().getSimpleName().startsWith("JNLP"));
        if (con instanceof HttpURLConnection) {
            ((HttpURLConnection)con).setRequestMethod("HEAD");
        }
    }

    public boolean isFileURL(URL url) {
        String protocol = url.getProtocol();
        return URL_PROTOCOL_FILE.equals(protocol) || URL_PROTOCOL_VFSFILE.equals(protocol) || URL_PROTOCOL_VFS.equals(protocol);
    }

    public File getFile() {
        try {
            return new File(new URI(this.url.toString()));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return null == this.url ? "null" : this.url.toString();
    }
}

