/*
 * Decompiled with CFR 0.152.
 */
package cn.vika.core.http;

import cn.vika.core.http.ClientHttpResponse;
import cn.vika.core.http.HttpStatus;
import cn.vika.core.http.ResponseBodyHandler;
import cn.vika.core.http.ResponseHandler;
import cn.vika.core.utils.IoUtil;
import cn.vika.core.utils.JacksonConverter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.lang.reflect.Type;

public class ResponseBodyExtractHandler<T>
implements ResponseHandler<T> {
    private final Type responseType;
    private PushbackInputStream pushbackInputStream;

    public ResponseBodyExtractHandler(Type responseType) {
        this.responseType = responseType;
    }

    @Override
    public T extractData(ClientHttpResponse response, ResponseBodyHandler handler) throws IOException {
        if (!this.hasBody(response) || this.hasEmptyBody(response)) {
            return null;
        }
        InputStream body = this.getBody(response);
        byte[] content = IoUtil.copyToByteArray(body);
        if (handler != null) {
            handler.handleBody(content);
        }
        return JacksonConverter.toGenericBean(content, this.responseType);
    }

    private boolean hasBody(ClientHttpResponse response) throws IOException {
        HttpStatus status = HttpStatus.resolve(response.getRawStatusCode());
        if (status != null && (status.is1xxInformational() || status == HttpStatus.NO_CONTENT || status == HttpStatus.NOT_MODIFIED)) {
            return false;
        }
        return response.getHeaders().getContentLength() != 0L;
    }

    public boolean hasEmptyBody(ClientHttpResponse response) throws IOException {
        InputStream body = response.getBody();
        if (body == null) {
            return true;
        }
        if (body.markSupported()) {
            body.mark(1);
            if (body.read() == -1) {
                return true;
            }
            body.reset();
            return false;
        }
        this.pushbackInputStream = new PushbackInputStream(body);
        int b = this.pushbackInputStream.read();
        if (b == -1) {
            return true;
        }
        this.pushbackInputStream.unread(b);
        return false;
    }

    private InputStream getBody(ClientHttpResponse response) throws IOException {
        return this.pushbackInputStream != null ? this.pushbackInputStream : response.getBody();
    }
}

