/*
 * Decompiled with CFR 0.152.
 */
package cn.vika.core.http;

import cn.vika.core.exception.HttpClientException;
import cn.vika.core.http.ClientHttpRequest;
import cn.vika.core.http.FormDataMap;
import cn.vika.core.http.HttpHeader;
import cn.vika.core.http.OnlyHeaderWrapper;
import cn.vika.core.http.ResourceLoader;
import cn.vika.core.utils.AssertUtil;
import cn.vika.core.utils.IoUtil;
import cn.vika.core.utils.JacksonConverter;
import cn.vika.core.utils.RandomUtil;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sf.jmimemagic.Magic;
import net.sf.jmimemagic.MagicException;
import net.sf.jmimemagic.MagicMatch;
import net.sf.jmimemagic.MagicMatchNotFoundException;
import net.sf.jmimemagic.MagicParseException;

public class RequestBodyWrapper
extends OnlyHeaderWrapper {
    private final Object requestBody;
    private final List<String> formDataMediaType = new ArrayList<String>();

    public RequestBodyWrapper(HttpHeader header, Object requestBody) {
        super(header);
        this.requestBody = requestBody;
        this.formDataMediaType.add("multipart/form-data");
        this.formDataMediaType.add("application/x-www-form-urlencoded");
        this.formDataMediaType.add("application/octet-stream");
    }

    @Override
    public void wrapper(ClientHttpRequest request) throws IOException {
        super.wrapper(request);
        if (this.requestBody != null) {
            HttpHeader requestHeaders;
            String requestContentType;
            Class<?> requestBodyClass = this.requestBody.getClass();
            if (this.isFormData(requestBodyClass, requestContentType = (requestHeaders = request.getHeaders()).getContentType())) {
                if (this.isMultiPart((FormDataMap)this.requestBody, requestContentType)) {
                    this.writeMultiPart(request, (FormDataMap)this.requestBody);
                } else {
                    this.writeForm(request, (FormDataMap)this.requestBody);
                }
            } else {
                request.getHeaders().setContentType("application/json");
                byte[] content = JacksonConverter.toJsonBytes(this.requestBody);
                request.getBody().write(content);
            }
        }
    }

    private boolean isFormData(Class<?> clazz, String contentType) {
        if (!FormDataMap.class.isAssignableFrom(clazz)) {
            return false;
        }
        if (contentType == null || "*/*".equals(contentType)) {
            return true;
        }
        for (String mediaType : this.formDataMediaType) {
            if (!mediaType.equalsIgnoreCase(contentType)) continue;
            return true;
        }
        return false;
    }

    private boolean isMultiPart(FormDataMap mapData, String contentType) {
        if (contentType != null) {
            return contentType.startsWith("multipart");
        }
        for (Object value : mapData.values()) {
            if (value == null || value instanceof String) continue;
            return true;
        }
        return false;
    }

    private void writeMultiPart(ClientHttpRequest request, FormDataMap parts) throws IOException {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        parameters.put("charset", StandardCharsets.UTF_8.name());
        byte[] boundary = RandomUtil.generateMultipartBoundary();
        parameters.put("boundary", new String(boundary, StandardCharsets.US_ASCII));
        StringBuilder contentType = new StringBuilder("multipart/form-data");
        parameters.forEach((key, value) -> contentType.append(';').append((String)key).append("=").append((String)value));
        request.getHeaders().setContentType(contentType.toString());
        OutputStream body = request.getBody();
        this.writeParts(body, parts, boundary);
        this.writeEnd(body, boundary);
        body.flush();
    }

    private void writeForm(ClientHttpRequest request, FormDataMap formData) throws IOException {
        StringBuilder builder = new StringBuilder();
        formData.forEach((name, value) -> {
            if (name == null) {
                AssertUtil.isTrue(value != null, "Null name in form data: " + formData);
                return;
            }
            try {
                if (builder.length() != 0) {
                    builder.append('&');
                }
                builder.append(URLEncoder.encode(name, StandardCharsets.UTF_8.name()));
                if (value != null) {
                    builder.append('=');
                    builder.append(URLEncoder.encode(String.valueOf(value), StandardCharsets.UTF_8.name()));
                }
            }
            catch (UnsupportedEncodingException ex) {
                throw new IllegalStateException(ex);
            }
        });
        byte[] bytes = builder.toString().getBytes(StandardCharsets.UTF_8);
        request.getHeaders().setContentLength(bytes.length);
        IoUtil.copy(bytes, request.getBody());
    }

    private void writeParts(OutputStream os, Map<String, Object> parts, byte[] boundary) throws IOException {
        for (Map.Entry<String, Object> entry : parts.entrySet()) {
            Object part = entry.getValue();
            if (part == null) continue;
            this.writeBoundary(os, boundary);
            this.writePart(os, entry.getKey(), part);
            this.writeNewLine(os);
        }
    }

    private void writePart(OutputStream os, String name, Object partBody) throws IOException {
        if (partBody == null) {
            throw new IllegalStateException("Empty body for part '" + name + "'");
        }
        HttpHeader httpHeader = new HttpHeader();
        if (partBody instanceof File) {
            File file = (File)partBody;
            httpHeader.setContentDispositionFormData(name, file.getName());
            this.defaultHeadersIfFileType(httpHeader, file);
            this.writeHeaders(os, httpHeader);
            byte[] data = Files.readAllBytes(file.toPath());
            IoUtil.copy(data, os);
        } else if (partBody instanceof ResourceLoader) {
            ResourceLoader loader = (ResourceLoader)partBody;
            httpHeader.setContentDispositionFormData(name, loader.getName());
            this.defaultHeadersIfResourceLoader(httpHeader, loader);
            this.writeHeaders(os, httpHeader);
            IoUtil.copy(loader.getInputStream(), os);
        } else {
            throw new HttpClientException("not support part param key " + name);
        }
    }

    private void writeHeaders(OutputStream os, HttpHeader headers) throws IOException {
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            byte[] headerName = entry.getKey().getBytes(StandardCharsets.UTF_8);
            for (String headerValueString : entry.getValue()) {
                byte[] headerValue = headerValueString.getBytes(StandardCharsets.UTF_8);
                os.write(headerName);
                os.write(58);
                os.write(32);
                os.write(headerValue);
                this.writeNewLine(os);
            }
        }
        this.writeNewLine(os);
    }

    private void writeBoundary(OutputStream os, byte[] boundary) throws IOException {
        os.write(45);
        os.write(45);
        os.write(boundary);
        this.writeNewLine(os);
    }

    private void writeNewLine(OutputStream os) throws IOException {
        os.write(13);
        os.write(10);
    }

    private void writeEnd(OutputStream os, byte[] boundary) throws IOException {
        os.write(45);
        os.write(45);
        os.write(boundary);
        os.write(45);
        os.write(45);
        this.writeNewLine(os);
    }

    private void defaultHeadersIfFileType(HttpHeader headers, File file) throws IOException {
        Long contentLength;
        String fileContentType;
        if (headers.getContentType() == null && (fileContentType = this.getFileMimeType(file)) != null) {
            headers.setContentType(fileContentType);
        }
        if (headers.getContentLength() < 0L && !headers.containsKey("Transfer-Encoding") && (contentLength = this.getContentLength(file)) != null) {
            headers.setContentLength(contentLength);
        }
    }

    private void defaultHeadersIfResourceLoader(HttpHeader headers, ResourceLoader loader) throws IOException {
        Long contentLength;
        String fileContentType;
        if (headers.getContentType() == null && (fileContentType = this.getFileMimeType(loader)) != null) {
            headers.setContentType(fileContentType);
        }
        if (headers.getContentLength() < 0L && !headers.containsKey("Transfer-Encoding") && (contentLength = this.getContentLength(loader)) != null) {
            headers.setContentLength(contentLength);
        }
    }

    private String getFileMimeType(File file) throws IOException {
        try {
            MagicMatch match = Magic.getMagicMatch((File)file, (boolean)false);
            return match.getMimeType();
        }
        catch (MagicException | MagicMatchNotFoundException | MagicParseException e) {
            return null;
        }
    }

    private String getFileMimeType(ResourceLoader loader) throws IOException {
        try {
            MagicMatch match = Magic.getMagicMatch((byte[])loader.readBytes(), (boolean)false);
            return match.getMimeType();
        }
        catch (MagicException | MagicMatchNotFoundException | MagicParseException e) {
            return null;
        }
    }

    private Long getContentLength(File file) throws IOException {
        long contentLength = file.length();
        return contentLength < 0L ? null : Long.valueOf(contentLength);
    }

    private Long getContentLength(ResourceLoader loader) throws IOException {
        long contentLength = loader.contentLength();
        return contentLength < 0L ? null : Long.valueOf(contentLength);
    }
}

