/*
 * Decompiled with CFR 0.152.
 */
package cn.vika.core.http;

import cn.vika.core.http.HttpHeader;
import cn.vika.core.utils.AssertUtil;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.internal.http.HttpMethod;

public class OkHttpRequestBuildFactory {
    private OkHttpClient client;
    private final boolean defaultClient;

    public OkHttpRequestBuildFactory() {
        this.client = new OkHttpClient();
        this.defaultClient = true;
    }

    public OkHttpRequestBuildFactory(OkHttpClient client) {
        AssertUtil.notNull(client, "OkHttpClient must not be null");
        this.client = client;
        this.defaultClient = false;
    }

    public void setReadTimeout(int readTimeout) {
        this.client = this.client.newBuilder().readTimeout((long)readTimeout, TimeUnit.MILLISECONDS).build();
    }

    public void setWriteTimeout(int writeTimeout) {
        this.client = this.client.newBuilder().writeTimeout((long)writeTimeout, TimeUnit.MILLISECONDS).build();
    }

    public void setConnectTimeout(int connectTimeout) {
        this.client = this.client.newBuilder().connectTimeout((long)connectTimeout, TimeUnit.MILLISECONDS).build();
    }

    static Request buildRequest(HttpHeader headers, byte[] content, URI uri, HttpMethod method) throws MalformedURLException {
        return null;
    }
}

