/*
 * Decompiled with CFR 0.152.
 */
package cn.vika.core.http;

import cn.vika.core.http.ClientHttpResponse;
import cn.vika.core.http.HttpHeader;
import cn.vika.core.utils.AssertUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class OkHttpClientHttpResponse
implements ClientHttpResponse {
    private final Response response;
    private volatile HttpHeader headers;

    public OkHttpClientHttpResponse(Response response) {
        AssertUtil.notNull(response, "Response must not be null");
        this.response = response;
    }

    @Override
    public int getRawStatusCode() throws IOException {
        return this.response.code();
    }

    @Override
    public String getStatusText() throws IOException {
        return this.response.message();
    }

    @Override
    public HttpHeader getHeaders() {
        HttpHeader headers = this.headers;
        if (headers == null) {
            headers = new HttpHeader();
            for (String headerName : this.response.headers().names()) {
                for (String headerValue : this.response.headers(headerName)) {
                    headers.add(headerName, headerValue);
                }
            }
            this.headers = headers;
        }
        return headers;
    }

    @Override
    public InputStream getBody() throws IOException {
        ResponseBody body = this.response.body();
        return body != null ? body.byteStream() : new ByteArrayInputStream(new byte[0]);
    }

    @Override
    public void close() {
        ResponseBody body = this.response.body();
        if (body != null) {
            body.close();
        }
    }
}

