/*
 * Decompiled with CFR 0.152.
 */
package cn.vika.core.http;

import cn.vika.core.http.ClientHttpRequest;
import cn.vika.core.http.ClientHttpRequestFactory;
import cn.vika.core.http.HttpHeader;
import cn.vika.core.http.HttpMethod;
import cn.vika.core.http.OkHttpClientRequest;
import cn.vika.core.utils.AssertUtil;
import cn.vika.core.utils.StringUtil;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;

public class OkHttpClientHttpRequestFactory
implements ClientHttpRequestFactory {
    private OkHttpClient client;

    public OkHttpClientHttpRequestFactory() {
        this.client = new OkHttpClient();
    }

    public OkHttpClientHttpRequestFactory(OkHttpClient client) {
        AssertUtil.notNull(client, "OkHttpClient must not be null");
        this.client = client;
    }

    public void setReadTimeout(int readTimeout) {
        this.client = this.client.newBuilder().readTimeout((long)readTimeout, TimeUnit.MILLISECONDS).build();
    }

    public void setConnectTimeout(int connectTimeout) {
        this.client = this.client.newBuilder().connectTimeout((long)connectTimeout, TimeUnit.MILLISECONDS).build();
    }

    @Override
    public ClientHttpRequest createRequest(URI uri, HttpMethod httpMethod) {
        return new OkHttpClientRequest(this.client, uri, httpMethod);
    }

    static Request buildRequest(URI uri, HttpMethod httpMethod, HttpHeader headers, byte[] content) throws MalformedURLException {
        MediaType contentType = OkHttpClientHttpRequestFactory.getContentType(headers);
        RequestBody body = content.length > 0 || okhttp3.internal.http.HttpMethod.requiresRequestBody((String)httpMethod.name()) ? RequestBody.create((byte[])content, (MediaType)contentType) : null;
        Request.Builder builder = new Request.Builder().url(uri.toURL()).method(httpMethod.name(), body);
        headers.forEach((headerName, headerValues) -> {
            for (String headerValue : headerValues) {
                builder.addHeader(headerName, headerValue);
            }
        });
        return builder.build();
    }

    private static MediaType getContentType(HttpHeader header) {
        String rawContentType = header.getFirstValue("Content-Type");
        return StringUtil.hasText(rawContentType) ? MediaType.parse((String)rawContentType) : null;
    }
}

