/*
 * Decompiled with CFR 0.152.
 */
package cn.vika.core.http;

import cn.vika.core.utils.AssertUtil;
import cn.vika.core.utils.StringUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class HttpHeader
implements Map<String, List<String>>,
Serializable {
    private static final long serialVersionUID = -7828980872691946594L;
    public static final String USER_AGENT = "User-Agent";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String CONTENT_LENGTH = "Content-Length";
    public static final String CONTENT_DISPOSITION = "Content-Disposition";
    public static final String AUTHORIZATION = "Authorization";
    public static final String TRANSFER_ENCODING = "Transfer-Encoding";
    final Map<String, List<String>> headers;

    public HttpHeader() {
        this(new LinkedHashMap<String, List<String>>(8, 0.75f));
    }

    public HttpHeader(Map<String, List<String>> headers) {
        AssertUtil.notNull(headers, "headers must not be null");
        this.headers = headers;
    }

    public List<String> getOrEmpty(Object headerName) {
        List<String> values = this.get(headerName);
        return values != null ? values : Collections.emptyList();
    }

    public String getFirstValue(String key) {
        List<String> values = this.headers.get(key);
        return values != null && !values.isEmpty() ? values.get(0) : null;
    }

    public void setUserAgent(String userAgent) {
        AssertUtil.hasText(userAgent, "userAgent is null");
        this.set(USER_AGENT, userAgent);
    }

    public void setBearerAuth(String token) {
        AssertUtil.hasText(token, "token is null");
        this.set(AUTHORIZATION, "Bearer " + token);
    }

    public long getContentLength() {
        String value = this.getFirstValue(CONTENT_LENGTH);
        return value != null ? Long.parseLong(value) : -1L;
    }

    public void setContentLength(long contentLength) {
        this.put(CONTENT_LENGTH, Collections.singletonList(Long.toString(contentLength)));
    }

    public void setContentType(String contentType) {
        this.put(CONTENT_TYPE, Collections.singletonList(contentType));
    }

    public String getContentType() {
        return this.getFirstValue(CONTENT_TYPE);
    }

    public void setContentDispositionFormData(String name, String filename) {
        AssertUtil.notNull(name, "Name must not be null");
        if (StringUtil.hasText(filename)) {
            this.setContentDisposition(HttpHeader.buildContentDisposition("form-data", name, filename));
        } else {
            this.setContentDisposition(HttpHeader.buildContentDisposition("form-data", name));
        }
    }

    public void setContentDisposition(String contentDisposition) {
        this.set(CONTENT_DISPOSITION, contentDisposition);
    }

    public void add(String headerName, String headerValue) {
        List values = this.headers.computeIfAbsent(headerName, k -> new ArrayList(1));
        values.add(headerValue);
    }

    public void addAll(String key, List<? extends String> values) {
        List currentValues = this.headers.computeIfAbsent(key, k -> new ArrayList(1));
        currentValues.addAll(values);
    }

    public void set(String headerName, String headerValue) {
        ArrayList<String> values = new ArrayList<String>(1);
        values.add(headerValue);
        this.headers.put(headerName, values);
    }

    public void setAll(Map<String, String> values) {
        values.forEach(this::set);
    }

    @Override
    public int size() {
        return this.headers.size();
    }

    @Override
    public boolean isEmpty() {
        return this.headers.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.headers.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.headers.containsValue(value);
    }

    @Override
    public List<String> get(Object key) {
        return this.headers.get(key);
    }

    @Override
    public List<String> put(String key, List<String> value) {
        return this.headers.put(key, value);
    }

    @Override
    public List<String> remove(Object key) {
        return this.headers.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends List<String>> map) {
        this.headers.putAll(map);
    }

    @Override
    public void clear() {
        this.headers.clear();
    }

    @Override
    @NotNull
    public Set<String> keySet() {
        return this.headers.keySet();
    }

    @Override
    @NotNull
    public Collection<List<String>> values() {
        return this.headers.values();
    }

    @Override
    @NotNull
    public Set<Map.Entry<String, List<String>>> entrySet() {
        return this.headers.entrySet();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof HttpHeader)) {
            return false;
        }
        return HttpHeader.unwrap(this).equals(HttpHeader.unwrap((HttpHeader)other));
    }

    private static Map<String, List<String>> unwrap(HttpHeader headers) {
        while (headers.headers instanceof HttpHeader) {
            headers = (HttpHeader)headers.headers;
        }
        return headers.headers;
    }

    @Override
    public int hashCode() {
        return this.headers.hashCode();
    }

    public String toString() {
        return HttpHeader.formatHeaders(this.headers);
    }

    public static String formatHeaders(Map<String, List<String>> headers) {
        return headers.entrySet().stream().map(entry -> {
            List values = (List)entry.getValue();
            return (String)entry.getKey() + ":" + (values.size() == 1 ? "\"" + (String)values.get(0) + "\"" : values.stream().map(s -> "\"" + s + "\"").collect(Collectors.joining(", ")));
        }).collect(Collectors.joining(", ", "[", "]"));
    }

    public static String buildContentDisposition(String type, String name) {
        StringBuilder sb = new StringBuilder();
        sb.append(type);
        sb.append("; name=\"");
        sb.append(name).append('\"');
        return sb.toString();
    }

    public static String buildContentDisposition(String type, String name, String filename) {
        StringBuilder sb = new StringBuilder();
        sb.append(type);
        sb.append("; name=\"");
        sb.append(name).append('\"');
        sb.append("; filename=\"");
        sb.append(HttpHeader.quoteFilename(filename)).append('\"');
        return sb.toString();
    }

    private static String quoteFilename(String filename) {
        if (filename.indexOf(34) == -1 && filename.indexOf(92) == -1) {
            return filename;
        }
        boolean escaped = false;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < filename.length(); ++i) {
            char c = filename.charAt(i);
            if (!escaped && c == '\"') {
                sb.append("\\\"");
            } else {
                sb.append(c);
            }
            escaped = !escaped && c == '\\';
        }
        if (escaped) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }
}

