/*
 * Decompiled with CFR 0.152.
 */
package cn.vika.core.http;

import cn.vika.core.utils.AssertUtil;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public abstract class GenericTypeReference<T> {
    private final Type type;

    protected GenericTypeReference() {
        Class<?> genericTypeReferenceSubclass = GenericTypeReference.findGenericTypeReferenceSubclass(this.getClass());
        Type type = genericTypeReferenceSubclass.getGenericSuperclass();
        AssertUtil.isInstanceOf(ParameterizedType.class, type, "Type must be a parameterized type");
        ParameterizedType parameterizedType = (ParameterizedType)type;
        Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
        AssertUtil.isTrue(actualTypeArguments.length == 1, "Number of type arguments must be 1");
        this.type = actualTypeArguments[0];
    }

    private GenericTypeReference(Type type) {
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof GenericTypeReference && this.type.equals(((GenericTypeReference)other).type);
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public String toString() {
        return "GenericTypeReference<" + this.type + ">";
    }

    public static <T> GenericTypeReference<T> forType(Type type) {
        return new GenericTypeReference<T>(type){};
    }

    private static Class<?> findGenericTypeReferenceSubclass(Class<?> child) {
        Class<?> parent = child.getSuperclass();
        if (Object.class == parent) {
            throw new IllegalStateException("Expected GenericTypeReference superclass");
        }
        if (GenericTypeReference.class == parent) {
            return child;
        }
        return GenericTypeReference.findGenericTypeReferenceSubclass(parent);
    }
}

