/*
 * Decompiled with CFR 0.152.
 */
package cn.vika.core.http;

import cn.vika.core.http.UriHandler;
import cn.vika.core.utils.StringUtil;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class DefaultUriBuildFactory
implements UriHandler {
    private String baseUri;
    private final Map<String, Object> defaultUriVariables = new HashMap<String, Object>();

    public DefaultUriBuildFactory() {
    }

    public DefaultUriBuildFactory(String baseUri) {
        this.baseUri = StringUtil.isEmpty(baseUri) ? "" : baseUri;
    }

    @Override
    public URI format(String uriTemplate, Map<String, ?> uriVariables) {
        if (this.checkUrl(uriTemplate)) {
            throw new IllegalArgumentException("Error Request Url");
        }
        if (!this.defaultUriVariables.isEmpty()) {
            HashMap<String, Object> map = new HashMap<String, Object>(this.defaultUriVariables);
            map.putAll(uriVariables);
            uriVariables = map;
        }
        String url = StringUtil.format(uriTemplate, uriVariables);
        return URI.create(this.baseUri + url);
    }

    @Override
    public URI format(String uriTemplate, Object ... uriVariables) {
        if (this.checkUrl(uriTemplate)) {
            throw new IllegalArgumentException("Error Request Url");
        }
        if (!this.defaultUriVariables.isEmpty() && this.isEmptyArray(uriVariables)) {
            return this.format(uriTemplate, Collections.emptyMap());
        }
        String url = StringUtil.format(uriTemplate, uriVariables);
        return URI.create(this.baseUri + url);
    }

    private boolean checkUrl(String uriString) {
        return !uriString.startsWith("/");
    }

    private boolean isEmptyArray(Object[] array) {
        return array == null || array.length == 0;
    }

    public void setDefaultUriVariables(Map<String, ?> defaultUriVariables) {
        this.defaultUriVariables.clear();
        if (defaultUriVariables != null) {
            this.defaultUriVariables.putAll(defaultUriVariables);
        }
    }

    public Map<String, ?> getDefaultUriVariables() {
        return Collections.unmodifiableMap(this.defaultUriVariables);
    }
}

