/*
 * Decompiled with CFR 0.152.
 */
package cn.vika.core.http;

import cn.vika.core.exception.ClientErrorException;
import cn.vika.core.exception.ServerErrorException;
import cn.vika.core.exception.UnknownHttpStatusCodeException;
import cn.vika.core.http.ClientHttpResponse;
import cn.vika.core.http.HttpHeader;
import cn.vika.core.http.HttpResponseErrorHandler;
import cn.vika.core.http.HttpStatus;
import cn.vika.core.utils.IoUtil;
import cn.vika.core.utils.ObjectUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;

public class DefaultHttpResponseErrorHandler
implements HttpResponseErrorHandler {
    @Override
    public void handlerError(ClientHttpResponse response) throws IOException {
        HttpStatus statusCode = HttpStatus.resolve(response.getRawStatusCode());
        if (statusCode == null) {
            byte[] body = this.getResponseBody(response);
            String message = this.getErrorMessage(response.getRawStatusCode(), response.getStatusText(), body);
            throw new UnknownHttpStatusCodeException(message, response.getRawStatusCode(), response.getStatusText(), response.getHeaders(), body);
        }
        this.handleError(response, statusCode);
    }

    protected void handleError(ClientHttpResponse response, HttpStatus statusCode) throws IOException {
        String statusText = response.getStatusText();
        HttpHeader headers = response.getHeaders();
        byte[] body = this.getResponseBody(response);
        String message = this.getErrorMessage(statusCode.code(), statusText, body);
        switch (statusCode.series()) {
            case CLIENT_ERROR: {
                throw new ClientErrorException(message, statusCode, statusText, headers, body);
            }
            case SERVER_ERROR: {
                throw new ServerErrorException(message, statusCode, statusText, headers, body);
            }
        }
        throw new UnknownHttpStatusCodeException(message, statusCode.code(), statusText, headers, body);
    }

    @Override
    public boolean hasError(ClientHttpResponse response) throws IOException {
        int rawStatusCode = response.getRawStatusCode();
        HttpStatus status = HttpStatus.resolve(rawStatusCode);
        return status != null ? this.hasError(status) : this.hasError(rawStatusCode);
    }

    protected boolean hasError(HttpStatus statusCode) {
        return statusCode.isError();
    }

    protected boolean hasError(int unknownRawStatusCode) {
        HttpStatus.Series series = HttpStatus.Series.resolve(unknownRawStatusCode);
        return series == HttpStatus.Series.CLIENT_ERROR || series == HttpStatus.Series.SERVER_ERROR;
    }

    protected byte[] getResponseBody(ClientHttpResponse response) {
        try {
            return IoUtil.readBytes(response.getBody());
        }
        catch (IOException iOException) {
            return new byte[0];
        }
    }

    private String getErrorMessage(int rawStatusCode, String statusText, byte[] responseBody) {
        String preface = rawStatusCode + " " + statusText + ": ";
        if (ObjectUtil.isEmpty(responseBody)) {
            return preface + "[no body]";
        }
        int maxChars = 200;
        if (responseBody.length < maxChars * 2) {
            return preface + "[" + new String(responseBody, StandardCharsets.UTF_8) + "]";
        }
        try {
            InputStreamReader reader = new InputStreamReader((InputStream)new ByteArrayInputStream(responseBody), StandardCharsets.UTF_8);
            CharBuffer buffer = CharBuffer.allocate(maxChars);
            ((Reader)reader).read(buffer);
            ((Reader)reader).close();
            buffer.flip();
            return preface + "[" + buffer.toString() + "... (" + responseBody.length + " bytes)]";
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

