/*
 * Decompiled with CFR 0.152.
 */
package cn.vika.core.http;

import cn.vika.core.exception.HttpClientException;
import cn.vika.core.http.AbstractHttpClient;
import cn.vika.core.http.ClientHttpRequestFactory;
import cn.vika.core.http.DefaultUriBuildFactory;
import cn.vika.core.http.GenericTypeReference;
import cn.vika.core.http.HttpHeader;
import cn.vika.core.http.HttpMethod;
import cn.vika.core.http.HttpResponseErrorHandler;
import cn.vika.core.http.IHttpClient;
import cn.vika.core.http.OnlyHeaderWrapper;
import cn.vika.core.http.RequestBodyWrapper;
import cn.vika.core.http.RequestWrapper;
import cn.vika.core.http.ResponseBodyExtractHandler;
import cn.vika.core.http.ResponseBodyHandler;
import cn.vika.core.http.ResponseHandler;
import cn.vika.core.http.UriHandler;
import cn.vika.core.utils.AssertUtil;
import java.net.URI;
import java.util.Map;

public class DefaultHttpClient
extends AbstractHttpClient
implements IHttpClient {
    private final UriHandler uriHandler;
    private final HttpHeader defaultHeaders = new HttpHeader();

    public DefaultHttpClient() {
        this.uriHandler = new DefaultUriBuildFactory();
    }

    public DefaultHttpClient(String baseUri) {
        if (baseUri.endsWith("/")) {
            baseUri = baseUri.substring(0, baseUri.length() - 2);
        }
        this.uriHandler = new DefaultUriBuildFactory(baseUri);
    }

    public DefaultHttpClient(ClientHttpRequestFactory requestFactory) {
        this();
        this.setRequestFactory(requestFactory);
    }

    public void addGlobalHeader(String headerName, String headerValue) {
        this.defaultHeaders.add(headerName, headerValue);
    }

    public void addGlobalHeader(HttpHeader headers) {
        this.defaultHeaders.putAll(headers);
    }

    public void setDefaultUriVariables(Map<String, ?> uriVars) {
        if (!(this.uriHandler instanceof DefaultUriBuildFactory)) {
            throw new IllegalArgumentException("not supported with the configured uriHandler.");
        }
        ((DefaultUriBuildFactory)this.uriHandler).setDefaultUriVariables(uriVars);
    }

    private UriHandler getUriHandler() {
        return this.uriHandler;
    }

    public void setErrorHandler(HttpResponseErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public HttpResponseErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public ResponseBodyHandler getResponseBodyHandler() {
        return this.responseBodyHandler;
    }

    public void setResponseBodyHandler(ResponseBodyHandler bodyHandler) {
        AssertUtil.notNull(this.errorHandler, "ResponseBodyHandler must not be null");
        this.responseBodyHandler = bodyHandler;
    }

    @Override
    public <T> T get(URI uri, HttpHeader header, Class<T> responseType) throws HttpClientException {
        OnlyHeaderWrapper requestWrapper = new OnlyHeaderWrapper(this.wrapperDefaultHeader(header));
        ResponseBodyExtractHandler responseHandler = new ResponseBodyExtractHandler(responseType);
        return this.execute(uri, HttpMethod.GET, requestWrapper, responseHandler);
    }

    @Override
    public <T> T get(String urlTemplate, HttpHeader header, Class<T> responseType, Object ... uriVariables) throws HttpClientException {
        OnlyHeaderWrapper requestWrapper = new OnlyHeaderWrapper(this.wrapperDefaultHeader(header));
        ResponseBodyExtractHandler responseHandler = new ResponseBodyExtractHandler(responseType);
        return this.execute(urlTemplate, HttpMethod.GET, (RequestWrapper)requestWrapper, responseHandler, uriVariables);
    }

    @Override
    public <T> T get(String urlTemplate, HttpHeader header, Class<T> responseType, Map<String, ?> uriVariables) throws HttpClientException {
        OnlyHeaderWrapper requestWrapper = new OnlyHeaderWrapper(this.wrapperDefaultHeader(header));
        ResponseBodyExtractHandler responseHandler = new ResponseBodyExtractHandler(responseType);
        return this.execute(urlTemplate, HttpMethod.GET, (RequestWrapper)requestWrapper, responseHandler, uriVariables);
    }

    @Override
    public <T> T get(String urlTemplate, HttpHeader header, GenericTypeReference<T> responseType, Map<String, ?> uriVariables) throws HttpClientException {
        OnlyHeaderWrapper requestWrapper = new OnlyHeaderWrapper(this.wrapperDefaultHeader(header));
        ResponseBodyExtractHandler responseHandler = new ResponseBodyExtractHandler(responseType.getType());
        return this.execute(urlTemplate, HttpMethod.GET, (RequestWrapper)requestWrapper, responseHandler, uriVariables);
    }

    @Override
    public <T> T get(String urlTemplate, HttpHeader header, GenericTypeReference<T> responseType, Object ... uriVariables) throws HttpClientException {
        OnlyHeaderWrapper requestWrapper = new OnlyHeaderWrapper(this.wrapperDefaultHeader(header));
        ResponseBodyExtractHandler responseHandler = new ResponseBodyExtractHandler(responseType.getType());
        return this.execute(urlTemplate, HttpMethod.GET, (RequestWrapper)requestWrapper, responseHandler, uriVariables);
    }

    @Override
    public <T> T post(URI uri, HttpHeader header, Object requestBody, Class<T> responseType) throws HttpClientException {
        RequestBodyWrapper requestWrapper = new RequestBodyWrapper(this.wrapperDefaultHeader(header), requestBody);
        ResponseBodyExtractHandler responseHandler = new ResponseBodyExtractHandler(responseType);
        return this.execute(uri, HttpMethod.POST, requestWrapper, responseHandler);
    }

    @Override
    public <T> T post(String urlTemplate, HttpHeader header, Object requestBody, Class<T> responseType, Object ... uriVariables) throws HttpClientException {
        RequestBodyWrapper requestWrapper = new RequestBodyWrapper(this.wrapperDefaultHeader(header), requestBody);
        ResponseBodyExtractHandler responseHandler = new ResponseBodyExtractHandler(responseType);
        return this.execute(urlTemplate, HttpMethod.POST, (RequestWrapper)requestWrapper, responseHandler, uriVariables);
    }

    @Override
    public <T> T post(String urlTemplate, HttpHeader header, Object requestBody, Class<T> responseType, Map<String, ?> uriVariables) throws HttpClientException {
        RequestBodyWrapper requestWrapper = new RequestBodyWrapper(this.wrapperDefaultHeader(header), requestBody);
        ResponseBodyExtractHandler responseHandler = new ResponseBodyExtractHandler(responseType);
        return this.execute(urlTemplate, HttpMethod.POST, (RequestWrapper)requestWrapper, responseHandler, uriVariables);
    }

    @Override
    public <T> T post(String urlTemplate, HttpHeader header, Object requestBody, GenericTypeReference<T> responseType, Map<String, ?> uriVariables) throws HttpClientException {
        RequestBodyWrapper requestWrapper = new RequestBodyWrapper(this.wrapperDefaultHeader(header), requestBody);
        ResponseBodyExtractHandler responseHandler = new ResponseBodyExtractHandler(responseType.getType());
        return this.execute(urlTemplate, HttpMethod.POST, (RequestWrapper)requestWrapper, responseHandler, uriVariables);
    }

    @Override
    public <T> T post(String urlTemplate, HttpHeader header, Object requestBody, GenericTypeReference<T> responseType, Object ... uriVariables) throws HttpClientException {
        RequestBodyWrapper requestWrapper = new RequestBodyWrapper(this.wrapperDefaultHeader(header), requestBody);
        ResponseBodyExtractHandler responseHandler = new ResponseBodyExtractHandler(responseType.getType());
        return this.execute(urlTemplate, HttpMethod.POST, (RequestWrapper)requestWrapper, responseHandler, uriVariables);
    }

    @Override
    public <T> T put(URI uri, HttpHeader header, Object requestBody, Class<T> responseType) throws HttpClientException {
        RequestBodyWrapper requestWrapper = new RequestBodyWrapper(this.wrapperDefaultHeader(header), requestBody);
        ResponseBodyExtractHandler responseHandler = new ResponseBodyExtractHandler(responseType);
        return this.execute(uri, HttpMethod.PUT, requestWrapper, responseHandler);
    }

    @Override
    public <T> T put(String urlTemplate, HttpHeader header, Object requestBody, Class<T> responseType, Object ... uriVariables) throws HttpClientException {
        RequestBodyWrapper requestWrapper = new RequestBodyWrapper(this.wrapperDefaultHeader(header), requestBody);
        ResponseBodyExtractHandler responseHandler = new ResponseBodyExtractHandler(responseType);
        return this.execute(urlTemplate, HttpMethod.PUT, (RequestWrapper)requestWrapper, responseHandler, uriVariables);
    }

    @Override
    public <T> T put(String urlTemplate, HttpHeader header, Object requestBody, Class<T> responseType, Map<String, ?> uriVariables) throws HttpClientException {
        RequestBodyWrapper requestWrapper = new RequestBodyWrapper(this.wrapperDefaultHeader(header), requestBody);
        ResponseBodyExtractHandler responseHandler = new ResponseBodyExtractHandler(responseType);
        return this.execute(urlTemplate, HttpMethod.PUT, (RequestWrapper)requestWrapper, responseHandler, uriVariables);
    }

    @Override
    public <T> T put(String urlTemplate, HttpHeader header, Object requestBody, GenericTypeReference<T> responseType, Map<String, ?> uriVariables) throws HttpClientException {
        RequestBodyWrapper requestWrapper = new RequestBodyWrapper(this.wrapperDefaultHeader(header), requestBody);
        ResponseBodyExtractHandler responseHandler = new ResponseBodyExtractHandler(responseType.getType());
        return this.execute(urlTemplate, HttpMethod.PUT, (RequestWrapper)requestWrapper, responseHandler, uriVariables);
    }

    @Override
    public <T> T put(String urlTemplate, HttpHeader header, Object requestBody, GenericTypeReference<T> responseType, Object ... uriVariables) throws HttpClientException {
        RequestBodyWrapper requestWrapper = new RequestBodyWrapper(this.wrapperDefaultHeader(header), requestBody);
        ResponseBodyExtractHandler responseHandler = new ResponseBodyExtractHandler(responseType.getType());
        return this.execute(urlTemplate, HttpMethod.PUT, (RequestWrapper)requestWrapper, responseHandler, uriVariables);
    }

    @Override
    public <T> T patch(URI uri, HttpHeader header, Object requestBody, Class<T> responseType) throws HttpClientException {
        RequestBodyWrapper requestWrapper = new RequestBodyWrapper(this.wrapperDefaultHeader(header), requestBody);
        ResponseBodyExtractHandler responseHandler = new ResponseBodyExtractHandler(responseType);
        return this.execute(uri, HttpMethod.PATCH, requestWrapper, responseHandler);
    }

    @Override
    public <T> T patch(String urlTemplate, HttpHeader header, Object requestBody, Class<T> responseType, Object ... uriVariables) throws HttpClientException {
        RequestBodyWrapper requestWrapper = new RequestBodyWrapper(this.wrapperDefaultHeader(header), requestBody);
        ResponseBodyExtractHandler responseHandler = new ResponseBodyExtractHandler(responseType);
        return this.execute(urlTemplate, HttpMethod.PATCH, (RequestWrapper)requestWrapper, responseHandler, uriVariables);
    }

    @Override
    public <T> T patch(String urlTemplate, HttpHeader header, Object requestBody, Class<T> responseType, Map<String, ?> uriVariables) throws HttpClientException {
        RequestBodyWrapper requestWrapper = new RequestBodyWrapper(this.wrapperDefaultHeader(header), requestBody);
        ResponseBodyExtractHandler responseHandler = new ResponseBodyExtractHandler(responseType);
        return this.execute(urlTemplate, HttpMethod.PATCH, (RequestWrapper)requestWrapper, responseHandler, uriVariables);
    }

    @Override
    public <T> T patch(String urlTemplate, HttpHeader header, Object requestBody, GenericTypeReference<T> responseType, Map<String, ?> uriVariables) throws HttpClientException {
        RequestBodyWrapper requestWrapper = new RequestBodyWrapper(this.wrapperDefaultHeader(header), requestBody);
        ResponseBodyExtractHandler responseHandler = new ResponseBodyExtractHandler(responseType.getType());
        return this.execute(urlTemplate, HttpMethod.PATCH, (RequestWrapper)requestWrapper, responseHandler, uriVariables);
    }

    @Override
    public <T> T patch(String urlTemplate, HttpHeader header, Object requestBody, GenericTypeReference<T> responseType, Object ... uriVariables) throws HttpClientException {
        RequestBodyWrapper requestWrapper = new RequestBodyWrapper(this.wrapperDefaultHeader(header), requestBody);
        ResponseBodyExtractHandler responseHandler = new ResponseBodyExtractHandler(responseType.getType());
        return this.execute(urlTemplate, HttpMethod.PATCH, (RequestWrapper)requestWrapper, responseHandler, uriVariables);
    }

    @Override
    public <T> T delete(URI uri, HttpHeader header, Class<T> responseType) throws HttpClientException {
        OnlyHeaderWrapper requestWrapper = new OnlyHeaderWrapper(this.wrapperDefaultHeader(header));
        ResponseBodyExtractHandler responseHandler = new ResponseBodyExtractHandler(responseType);
        return this.execute(uri, HttpMethod.GET, requestWrapper, responseHandler);
    }

    @Override
    public <T> T delete(String urlTemplate, HttpHeader header, Class<T> responseType, Object ... uriVariables) throws HttpClientException {
        OnlyHeaderWrapper requestWrapper = new OnlyHeaderWrapper(this.wrapperDefaultHeader(header));
        ResponseBodyExtractHandler responseHandler = new ResponseBodyExtractHandler(responseType);
        return this.execute(urlTemplate, HttpMethod.DELETE, (RequestWrapper)requestWrapper, responseHandler, uriVariables);
    }

    @Override
    public <T> T delete(String urlTemplate, HttpHeader header, Class<T> responseType, Map<String, ?> uriVariables) throws HttpClientException {
        OnlyHeaderWrapper requestWrapper = new OnlyHeaderWrapper(this.wrapperDefaultHeader(header));
        ResponseBodyExtractHandler responseHandler = new ResponseBodyExtractHandler(responseType);
        return this.execute(urlTemplate, HttpMethod.DELETE, (RequestWrapper)requestWrapper, responseHandler, uriVariables);
    }

    @Override
    public <T> T delete(String urlTemplate, HttpHeader header, GenericTypeReference<T> responseType, Object ... uriVariables) throws HttpClientException {
        OnlyHeaderWrapper requestWrapper = new OnlyHeaderWrapper(this.wrapperDefaultHeader(header));
        ResponseBodyExtractHandler responseHandler = new ResponseBodyExtractHandler(responseType.getType());
        return this.execute(urlTemplate, HttpMethod.DELETE, (RequestWrapper)requestWrapper, responseHandler, uriVariables);
    }

    @Override
    public <T> T delete(String urlTemplate, HttpHeader header, GenericTypeReference<T> responseType, Map<String, ?> uriVariables) throws HttpClientException {
        OnlyHeaderWrapper requestWrapper = new OnlyHeaderWrapper(this.wrapperDefaultHeader(header));
        ResponseBodyExtractHandler responseHandler = new ResponseBodyExtractHandler(responseType.getType());
        return this.execute(urlTemplate, HttpMethod.DELETE, (RequestWrapper)requestWrapper, responseHandler, uriVariables);
    }

    protected <T> T execute(URI uri, HttpMethod method, RequestWrapper requestWrapper, ResponseHandler<T> responseHandler) throws HttpClientException {
        return this.doExecute(uri, method, requestWrapper, responseHandler);
    }

    protected <T> T execute(String urlTemplate, HttpMethod method, RequestWrapper requestWrapper, ResponseHandler<T> responseHandler, Object ... uriVariables) throws HttpClientException {
        URI expandedUri = this.getUriHandler().format(urlTemplate, uriVariables);
        return this.doExecute(expandedUri, method, requestWrapper, responseHandler);
    }

    protected <T> T execute(String urlTemplate, HttpMethod method, RequestWrapper requestWrapper, ResponseHandler<T> responseHandler, Map<String, ?> uriVariables) throws HttpClientException {
        URI expandedUri = this.getUriHandler().format(urlTemplate, uriVariables);
        return this.doExecute(expandedUri, method, requestWrapper, responseHandler);
    }

    private HttpHeader wrapperDefaultHeader(HttpHeader httpHeader) {
        if (!this.defaultHeaders.isEmpty()) {
            this.defaultHeaders.forEach(httpHeader::put);
        }
        return httpHeader;
    }
}

