/*
 * Decompiled with CFR 0.152.
 */
package cn.vika.core.http;

import cn.vika.core.http.UrlResourceLoader;
import cn.vika.core.utils.AssertUtil;
import cn.vika.core.utils.StringUtil;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class ClassPathResourceLoader
extends UrlResourceLoader {
    private static final String CLASSPATH_URL_PREFIX = "classpath:";
    public static final String FILE_URL_PREFIX = "file:";
    private final String path;
    private final ClassLoader classLoader;
    private final Class<?> clazz;

    public ClassPathResourceLoader(String path) {
        this(path, null, null);
    }

    public ClassPathResourceLoader(String path, ClassLoader classLoader) {
        this(path, classLoader, null);
    }

    public ClassPathResourceLoader(String path, Class<?> clazz) {
        this(path, null, clazz);
    }

    public ClassPathResourceLoader(String pathBaseClassLoader, ClassLoader classLoader, Class<?> clazz) {
        super(null);
        String path;
        AssertUtil.notNull(pathBaseClassLoader, "Path must not be null");
        this.path = path = this.normalizePath(pathBaseClassLoader);
        this.name = StringUtil.hasText(path) ? StringUtil.getName(path) : null;
        this.classLoader = classLoader != null ? classLoader : ClassPathResourceLoader.getClassLoader();
        this.clazz = clazz;
        this.initUrl();
    }

    private void initUrl() {
        this.url = null != this.clazz ? this.clazz.getResource(this.path) : (null != this.classLoader ? this.classLoader.getResource(this.path) : ClassLoader.getSystemResource(this.path));
        if (null == this.url) {
            throw new RuntimeException("Resource of path [" + this.path + "] not exist!");
        }
    }

    private static ClassLoader getClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null && null == (classLoader = ClassPathResourceLoader.class.getClassLoader())) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        return classLoader;
    }

    private String normalizePath(String path) {
        path = this.normalize(path);
        AssertUtil.isTrue(!this.isAbsolutePath(path = StringUtil.removePrefix(path, "/")), "Path [" + path + "] must be a relative path !");
        return path;
    }

    private boolean isAbsolutePath(String path) {
        return '/' == path.charAt(0) || path.matches("^[a-zA-Z]:([/\\\\].*)?");
    }

    private String normalize(String path) {
        if (path == null) {
            return null;
        }
        String pathToUse = StringUtil.removePrefixIgnoreCase(path, CLASSPATH_URL_PREFIX);
        if (!StringUtil.hasText(pathToUse = StringUtil.removePrefixIgnoreCase(pathToUse, FILE_URL_PREFIX))) {
            return "";
        }
        if (pathToUse.startsWith("~")) {
            pathToUse = pathToUse.replace("~", System.getProperty("user.home"));
        }
        pathToUse = pathToUse.replaceAll("[/\\\\]+", "/").trim();
        if (path.startsWith("\\\\")) {
            pathToUse = "\\" + pathToUse;
        }
        String prefix = "";
        int prefixIndex = pathToUse.indexOf(":");
        if (prefixIndex > -1) {
            prefix = pathToUse.substring(0, prefixIndex + 1);
            if (prefix.startsWith("/")) {
                prefix = prefix.substring(1);
            }
            if (!prefix.contains("/")) {
                pathToUse = pathToUse.substring(prefixIndex + 1);
            } else {
                prefix = "";
            }
        }
        if (pathToUse.startsWith("/")) {
            prefix = prefix + "/";
            pathToUse = pathToUse.substring(1);
        }
        List<String> pathList = Arrays.asList(pathToUse.split("/"));
        LinkedList<String> pathElements = new LinkedList<String>();
        int tops = 0;
        for (int i = pathList.size() - 1; i >= 0; --i) {
            String element = pathList.get(i);
            if (".".equals(element)) continue;
            if ("..".equals(element)) {
                ++tops;
                continue;
            }
            if (tops > 0) {
                --tops;
                continue;
            }
            pathElements.add(0, element);
        }
        return prefix + StringUtil.join(pathElements, "/");
    }

    @Override
    public String toString() {
        return null == this.path ? super.toString() : CLASSPATH_URL_PREFIX + this.path;
    }
}

