/*
 * Decompiled with CFR 0.152.
 */
package cn.vika.core.http;

import cn.vika.core.exception.HttpClientException;
import cn.vika.core.http.ClientHttpRequest;
import cn.vika.core.http.ClientHttpRequestFactory;
import cn.vika.core.http.ClientHttpResponse;
import cn.vika.core.http.DefaultHttpResponseErrorHandler;
import cn.vika.core.http.HttpMethod;
import cn.vika.core.http.HttpResponseErrorHandler;
import cn.vika.core.http.OkHttpClientHttpRequestFactory;
import cn.vika.core.http.RequestWrapper;
import cn.vika.core.http.ResponseBodyHandler;
import cn.vika.core.http.ResponseHandler;
import cn.vika.core.utils.AssertUtil;
import java.io.IOException;
import java.net.URI;

public abstract class AbstractHttpClient {
    private ClientHttpRequestFactory requestFactory = new OkHttpClientHttpRequestFactory();
    protected HttpResponseErrorHandler errorHandler = new DefaultHttpResponseErrorHandler();
    protected ResponseBodyHandler responseBodyHandler;

    public void setRequestFactory(ClientHttpRequestFactory requestFactory) {
        AssertUtil.notNull(requestFactory, "HttpRequestFactory must not be null");
        this.requestFactory = requestFactory;
    }

    public ClientHttpRequestFactory getRequestFactory() {
        return this.requestFactory;
    }

    protected ClientHttpRequest createRequest(URI uri, HttpMethod method) throws IOException {
        return this.getRequestFactory().createRequest(uri, method);
    }

    protected <T> T doExecute(URI uri, HttpMethod method, RequestWrapper requestWrapper, ResponseHandler<T> responseHandler) throws HttpClientException {
        AssertUtil.notNull(uri, "URI is required");
        AssertUtil.notNull((Object)method, "HttpMethod is required");
        try (ClientHttpResponse response = null;){
            ClientHttpRequest request = this.createRequest(uri, method);
            if (requestWrapper != null) {
                requestWrapper.wrapper(request);
            }
            response = request.execute();
            this.handlerResponse(response);
            T t = responseHandler != null ? (T)responseHandler.extractData(response, this.responseBodyHandler) : null;
            return t;
        }
    }

    private void handlerResponse(ClientHttpResponse response) throws IOException {
        boolean hasError = this.errorHandler.hasError(response);
        if (hasError) {
            this.errorHandler.handlerError(response);
        }
    }
}

