/*
 * Decompiled with CFR 0.152.
 */
package cn.vika.core.http;

import cn.vika.core.http.ClientHttpRequest;
import cn.vika.core.http.ClientHttpResponse;
import cn.vika.core.http.HttpHeader;
import cn.vika.core.utils.AssertUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public abstract class AbstractClientHttpRequest
implements ClientHttpRequest {
    private final HttpHeader headers = new HttpHeader();
    private ByteArrayOutputStream bufferedOutput = new ByteArrayOutputStream(1024);
    private boolean executed = false;

    @Override
    public HttpHeader getHeaders() {
        return this.headers;
    }

    @Override
    public OutputStream getBody() throws IOException {
        return this.bufferedOutput;
    }

    @Override
    public ClientHttpResponse execute() throws IOException {
        this.assertNotExecuted();
        byte[] bytes = this.bufferedOutput.toByteArray();
        if (this.headers.getContentLength() < 0L) {
            this.headers.setContentLength(bytes.length);
        }
        ClientHttpResponse result = this.executeInternal(this.headers, bytes);
        this.bufferedOutput = new ByteArrayOutputStream(0);
        this.executed = true;
        return result;
    }

    protected void assertNotExecuted() {
        AssertUtil.state(!this.executed, "Client already executed");
    }

    protected abstract ClientHttpResponse executeInternal(HttpHeader var1, byte[] var2) throws IOException;
}

