/*
 * Decompiled with CFR 0.152.
 */
package cn.vika.core.exception;

import cn.vika.core.exception.HttpClientException;
import cn.vika.core.http.HttpHeader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class HttpResponseException
extends HttpClientException {
    private static final long serialVersionUID = -7458140335323974708L;
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private final int rawStatusCode;
    private final String statusText;
    private final HttpHeader responseHeaders;
    private final byte[] responseBody;

    public HttpResponseException(String message, int rawStatusCode, String statusText, HttpHeader responseHeaders, byte[] responseBody) {
        super(message);
        this.rawStatusCode = rawStatusCode;
        this.statusText = statusText;
        this.responseHeaders = responseHeaders;
        this.responseBody = responseBody;
    }

    public int getRawStatusCode() {
        return this.rawStatusCode;
    }

    public String getStatusText() {
        return this.statusText;
    }

    public HttpHeader getResponseHeaders() {
        return this.responseHeaders;
    }

    public byte[] getResponseBodyAsByteArray() {
        return this.responseBody;
    }

    public String getResponseBodyAsString() {
        return new String(this.responseBody, DEFAULT_CHARSET);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("code:").append(this.rawStatusCode).append(",");
        sb.append("statusText:").append(this.statusText).append(",");
        this.responseHeaders.forEach((k, v) -> sb.append((String)k).append(":").append(v.toString()).append(","));
        sb.append("body:").append(new String(this.responseBody, StandardCharsets.UTF_8)).append(",");
        return sb.toString();
    }
}

