/*
 * Decompiled with CFR 0.152.
 */
package cn.vika.client.api.model;

import cn.vika.client.api.exception.ApiException;
import cn.vika.client.api.http.AbstractApi;
import cn.vika.client.api.model.ApiQueryParam;
import cn.vika.client.api.model.HttpResult;
import cn.vika.client.api.model.PagerInfo;
import cn.vika.core.http.GenericTypeReference;
import cn.vika.core.http.HttpHeader;
import cn.vika.core.utils.JacksonConverter;
import cn.vika.core.utils.MapUtil;
import com.fasterxml.jackson.databind.JavaType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.stream.Stream;

public class Pager<T>
implements Iterator<List<T>> {
    private int itemsPerPage;
    private int totalPages;
    private int totalItems;
    private int currentPage;
    private List<T> currentItems;
    private Stream<T> pagerStream = null;
    private ApiQueryParam queryParam;
    private AbstractApi api;
    private String url;
    private JavaType javaType;

    public Pager(AbstractApi api, String url, int itemsPerPage, Class<T> type) throws ApiException {
        this.javaType = JacksonConverter.getCollectionJavaType(type);
        this.api = api;
        this.url = url;
        if (itemsPerPage < 1) {
            itemsPerPage = api.getDefaultPerPage();
        }
        this.queryParam = new ApiQueryParam(1, itemsPerPage);
        Map<String, String> uriVariables = this.queryParam.toMap();
        GenericTypeReference reference = new GenericTypeReference<HttpResult<PagerInfo<T>>>(){};
        String uri = url + MapUtil.extractKeyToVariables(uriVariables);
        HttpResult result = (HttpResult)api.getDefaultHttpClient().get(uri, new HttpHeader(), reference, uriVariables);
        if (((PagerInfo)result.getData()).getRecords() != null) {
            this.currentItems = (List)JacksonConverter.toGenericBean(((PagerInfo)result.getData()).getRecords(), (JavaType)this.javaType);
            if (this.currentItems == null) {
                throw new ApiException("Invalid response from server");
            }
        } else {
            this.currentItems.clear();
        }
        this.itemsPerPage = ((PagerInfo)result.getData()).getPageSize();
        this.totalItems = ((PagerInfo)result.getData()).getTotal();
        this.totalPages = this.totalItems == 0 ? 1 : (this.totalItems - 1) / this.itemsPerPage + 1;
    }

    public Pager(AbstractApi api, String url, ApiQueryParam queryParam, Class<T> type) throws ApiException {
        this.api = api;
        this.url = url;
        this.queryParam = queryParam;
        this.javaType = JacksonConverter.getCollectionJavaType(type);
        GenericTypeReference reference = new GenericTypeReference<HttpResult<PagerInfo<T>>>(){};
        Map<String, String> uriVariables = this.queryParam.toMap();
        String uri = url + MapUtil.extractKeyToVariables(uriVariables);
        HttpResult result = (HttpResult)api.getDefaultHttpClient().get(uri, new HttpHeader(), reference, uriVariables);
        if (((PagerInfo)result.getData()).getRecords() != null) {
            this.currentItems = (List)JacksonConverter.toGenericBean(((PagerInfo)result.getData()).getRecords(), (JavaType)this.javaType);
            if (this.currentItems == null) {
                throw new ApiException("Invalid response from server");
            }
        } else {
            this.currentItems.clear();
        }
        this.itemsPerPage = ((PagerInfo)result.getData()).getPageSize();
        this.totalItems = ((PagerInfo)result.getData()).getTotal();
        this.totalPages = this.totalItems == 0 ? 1 : (this.totalItems - 1) / this.itemsPerPage + 1;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public int getTotalPages() {
        return this.totalPages;
    }

    public int getItemsPerPage() {
        return this.itemsPerPage;
    }

    public int getTotalItems() {
        return this.totalItems;
    }

    @Override
    public boolean hasNext() {
        return this.currentPage < this.totalPages;
    }

    @Override
    public List<T> next() {
        return this.page(this.currentPage + 1);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public List<T> first() {
        return this.page(1);
    }

    public List<T> last() {
        return this.page(this.totalPages);
    }

    public List<T> page(int pageNumber) {
        if (pageNumber > this.totalPages) {
            throw new NoSuchElementException();
        }
        if (pageNumber < 1) {
            throw new NoSuchElementException();
        }
        if (this.currentPage == 0 && pageNumber == 1) {
            this.currentPage = 1;
            return this.currentItems;
        }
        if (this.currentPage == pageNumber) {
            return this.currentItems;
        }
        this.queryParam.withParam("pageNum", Integer.toString(pageNumber));
        Map<String, String> uriVariables = this.queryParam.toMap();
        GenericTypeReference reference = new GenericTypeReference<HttpResult<PagerInfo<T>>>(){};
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        String uri = this.url + MapUtil.extractKeyToVariables(uriVariables);
        HttpResult result = (HttpResult)this.api.getDefaultHttpClient().get(uri, new HttpHeader(), reference, uriVariables);
        if (((PagerInfo)result.getData()).getRecords() != null) {
            this.currentItems = (List)JacksonConverter.toGenericBean(((PagerInfo)result.getData()).getRecords(), (JavaType)this.javaType);
        } else {
            this.currentItems.clear();
        }
        this.currentPage = pageNumber;
        return this.currentItems;
    }

    public List<T> all() {
        this.currentPage = 0;
        ArrayList allItems = new ArrayList(Math.max(this.totalItems, 0));
        while (this.hasNext()) {
            allItems.addAll(this.next());
        }
        return allItems;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stream<T> stream() throws IllegalStateException {
        if (this.pagerStream == null) {
            Pager pager = this;
            synchronized (pager) {
                if (this.pagerStream == null) {
                    this.currentPage = 0;
                    Stream.Builder streamBuilder = Stream.builder();
                    while (this.hasNext()) {
                        this.next().forEach(streamBuilder);
                    }
                    this.pagerStream = streamBuilder.build();
                    return this.pagerStream;
                }
            }
        }
        throw new IllegalStateException("Stream already issued");
    }
}

