/*
 * Decompiled with CFR 0.152.
 */
package cn.vika.client.api.model;

import java.io.Serializable;

public class HttpResult<T>
implements Serializable {
    private static final long serialVersionUID = -7209417159215144399L;
    private boolean success;
    private int code;
    private String message;
    private T data;

    public HttpResult() {
    }

    public HttpResult(int code, String message) {
        this.code = code;
        this.message = message;
    }

    public HttpResult(int code, T data) {
        this.code = code;
        this.data = data;
    }

    public HttpResult(int code, String message, T data) {
        this.code = code;
        this.message = message;
        this.data = data;
    }

    public HttpResult(boolean success, int code, String message, T data) {
        this.success = success;
        this.code = code;
        this.message = message;
        this.data = data;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public String toString() {
        return "HttpResult{success=" + this.success + "code=" + this.code + ", message='" + this.message + '\'' + ", data=" + this.data + '}';
    }

    public static <T> HttpResultBuilder<T> builder() {
        return new HttpResultBuilder();
    }

    public static final class HttpResultBuilder<T> {
        private boolean success;
        private int code;
        private String errMsg;
        private T data;

        private HttpResultBuilder() {
        }

        public HttpResultBuilder<T> withSuccess(boolean success) {
            this.success = success;
            return this;
        }

        public HttpResultBuilder<T> withCode(int code) {
            this.code = code;
            return this;
        }

        public HttpResultBuilder<T> withMsg(String errMsg) {
            this.errMsg = errMsg;
            return this;
        }

        public HttpResultBuilder<T> withData(T data) {
            this.data = data;
            return this;
        }

        public HttpResult<T> build() {
            HttpResult<T> restResult = new HttpResult<T>();
            restResult.setCode(this.code);
            restResult.setMessage(this.errMsg);
            restResult.setData(this.data);
            return restResult;
        }
    }
}

