/*
 * Decompiled with CFR 0.152.
 */
package cn.vika.client.api.model;

import cn.vika.client.api.model.CellFormat;
import cn.vika.client.api.model.FieldKey;
import cn.vika.client.api.model.Order;
import cn.vika.client.api.util.UrlEncoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ApiQueryParam
extends HashMap<String, List<String>> {
    private Map<String, Order> orderByMap = new LinkedHashMap<String, Order>(16);
    public static ApiQueryParam EMPTY = new ApiQueryParam();

    public ApiQueryParam() {
        super(16);
    }

    public ApiQueryParam(HashMap<String, List<String>> map) {
        super(map);
    }

    public ApiQueryParam(int page, int pageSize) {
        super(16);
        this.withParam("pageNum", Integer.toString(page));
        this.withParam("pageSize", Integer.toString(pageSize));
    }

    public ApiQueryParam withSort(String fieldName, Order order) {
        this.orderByMap.put(fieldName, order);
        return this;
    }

    public ApiQueryParam withView(String viewId) {
        return this.withParam("viewId", viewId);
    }

    public ApiQueryParam withRecordIds(List<String> recordIds) {
        return this.withParam("recordIds", recordIds);
    }

    public ApiQueryParam withFields(List<String> fieldNames) {
        return this.withParam("fields", fieldNames);
    }

    public ApiQueryParam withFilter(String formula) {
        return this.withParam("filterByFormula", UrlEncoder.encodeURIComponent(formula));
    }

    public ApiQueryParam withMaxRecords(int maxRecords) {
        return this.withParam("maxRecords", Integer.toString(maxRecords));
    }

    public ApiQueryParam withCellFormat(CellFormat cellFormat) {
        return this.withParam("cellFormat", cellFormat.name().toLowerCase());
    }

    public ApiQueryParam withFieldKey(FieldKey fieldKey) {
        return this.withParam("fieldKey", fieldKey.name().toLowerCase());
    }

    public ApiQueryParam withParam(String key, String value) {
        if (value == null) {
            return this;
        }
        this.put(key, Collections.singletonList(value));
        return this;
    }

    public ApiQueryParam withParam(String key, List<String> value) {
        if (value == null) {
            return this;
        }
        this.put(key, value);
        return this;
    }

    public Map<String, String> toMap() {
        HashMap<String, String> queryMap = new HashMap<String, String>();
        for (Map.Entry entry : this.entrySet()) {
            if (((List)entry.getValue()).size() == 1) {
                queryMap.put((String)entry.getKey(), (String)((List)entry.getValue()).get(0));
                continue;
            }
            if (((List)entry.getValue()).size() <= 1) continue;
            for (int i = 0; i < ((List)entry.getValue()).size(); ++i) {
                queryMap.put((String)entry.getKey() + "." + i, (String)((List)entry.getValue()).get(i));
            }
        }
        if (!this.orderByMap.isEmpty()) {
            int i = 0;
            for (Map.Entry<String, Order> entry : this.orderByMap.entrySet()) {
                queryMap.put("sort." + i + ".field", entry.getKey());
                queryMap.put("sort." + i + ".order", entry.getValue().name().toLowerCase());
                ++i;
            }
        }
        return queryMap;
    }
}

