/*
 * Decompiled with CFR 0.152.
 */
package cn.vika.client.api.http;

import cn.vika.client.api.http.ApiCredential;
import cn.vika.client.api.http.ApiResponseErrorHandler;
import cn.vika.core.http.ClientHttpRequestFactory;
import cn.vika.core.http.DefaultHttpClient;
import cn.vika.core.http.HttpHeader;
import cn.vika.core.http.OkHttpClientHttpRequestFactory;
import cn.vika.core.http.ResponseBodyHandler;

public class ApiHttpClient {
    public static final int DEFAULT_PER_PAGE = 100;
    public static final int DEFAULT_CONNECT_TIMEOUT = 60000;
    public static final int DEFAULT_READ_TIMEOUT = 60000;
    private final DefaultHttpClient defaultHttpClient;
    private int defaultPerPage = 100;
    private Integer connectTimeout = 60000;
    private Integer readTimeout = 60000;

    public ApiHttpClient(ApiVersion apiVersion, String baseUrl, ApiCredential apiCredential) {
        baseUrl = baseUrl + apiVersion.getApiNamespace();
        this.defaultHttpClient = new DefaultHttpClient(baseUrl);
        HttpHeader header = this.setDefaultHeader(apiCredential);
        this.defaultHttpClient.addGlobalHeader(header);
        this.defaultHttpClient.setResponseBodyHandler((ResponseBodyHandler)new ApiResponseErrorHandler());
    }

    private HttpHeader setDefaultHeader(ApiCredential apiCredential) {
        HttpHeader header = new HttpHeader();
        header.setUserAgent("vika-java-client");
        header.setBearerAuth(apiCredential.getToken());
        return header;
    }

    public void setConnectTimeout(Integer connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setReadTimeout(Integer readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void setDefaultPerPage(int defaultPerPage) {
        this.defaultPerPage = defaultPerPage;
    }

    public int getDefaultPerPage() {
        return this.defaultPerPage;
    }

    public DefaultHttpClient getDefaultHttpClient() {
        ClientHttpRequestFactory requestFactory;
        if (this.connectTimeout != null && (requestFactory = this.defaultHttpClient.getRequestFactory()) instanceof OkHttpClientHttpRequestFactory) {
            ((OkHttpClientHttpRequestFactory)requestFactory).setConnectTimeout(this.connectTimeout.intValue());
        }
        if (this.readTimeout != null && (requestFactory = this.defaultHttpClient.getRequestFactory()) instanceof OkHttpClientHttpRequestFactory) {
            ((OkHttpClientHttpRequestFactory)requestFactory).setReadTimeout(this.readTimeout.intValue());
        }
        return this.defaultHttpClient;
    }

    public static enum ApiVersion {
        V1;


        public String getApiNamespace() {
            return "/fusion/" + this.name().toLowerCase();
        }
    }
}

