/*
 * Decompiled with CFR 0.152.
 */
package cn.vika.client.api;

import cn.vika.client.api.AttachmentApi;
import cn.vika.client.api.RecordApi;
import cn.vika.client.api.http.ApiCredential;
import cn.vika.client.api.http.ApiHttpClient;

public class VikaApiClient {
    private static final String DEFAULT_HOST = "https://api.vika.cn";
    private final ApiHttpClient.ApiVersion apiVersion;
    private final ApiHttpClient apiHttpClient;
    private RecordApi recordApi;
    private AttachmentApi attachmentApi;

    public VikaApiClient(ApiCredential credential) {
        this(ApiHttpClient.ApiVersion.V1, DEFAULT_HOST, credential);
    }

    public VikaApiClient(String hostUrl, ApiCredential credential) {
        this(ApiHttpClient.ApiVersion.V1, hostUrl, credential);
    }

    public VikaApiClient(ApiHttpClient.ApiVersion apiVersion, String hostUrl, ApiCredential credential) {
        this.apiVersion = apiVersion;
        this.apiHttpClient = new ApiHttpClient(apiVersion, hostUrl, credential);
    }

    public ApiHttpClient.ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    public int getDefaultPerPage() {
        return this.apiHttpClient.getDefaultPerPage();
    }

    public void setDefaultPerPage(int defaultPerPage) {
        this.apiHttpClient.setDefaultPerPage(defaultPerPage);
    }

    public void setRequestTimeout(Integer connectTimeout) {
        this.apiHttpClient.setConnectTimeout(connectTimeout);
    }

    public VikaApiClient withRequestTimeout(Integer connectTimeout) {
        this.apiHttpClient.setConnectTimeout(connectTimeout);
        return this;
    }

    public void setReadTimeout(Integer readTimeout) {
        this.apiHttpClient.setReadTimeout(readTimeout);
    }

    public VikaApiClient withReadTimeout(Integer readTimeout) {
        this.apiHttpClient.setReadTimeout(readTimeout);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecordApi getRecordApi() {
        if (this.recordApi == null) {
            VikaApiClient vikaApiClient = this;
            synchronized (vikaApiClient) {
                if (this.recordApi == null) {
                    this.recordApi = new RecordApi(this.apiHttpClient);
                }
            }
        }
        return this.recordApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttachmentApi getAttachmentApi() {
        if (this.attachmentApi == null) {
            VikaApiClient vikaApiClient = this;
            synchronized (vikaApiClient) {
                if (this.attachmentApi == null) {
                    this.attachmentApi = new AttachmentApi(this.apiHttpClient);
                }
            }
        }
        return this.attachmentApi;
    }
}

