/*
 * Decompiled with CFR 0.152.
 */
package cn.vika.client.api;

import cn.vika.client.api.exception.ApiException;
import cn.vika.client.api.http.AbstractApi;
import cn.vika.client.api.http.ApiHttpClient;
import cn.vika.client.api.model.ApiQueryParam;
import cn.vika.client.api.model.CreateRecordRequest;
import cn.vika.client.api.model.HttpResult;
import cn.vika.client.api.model.Pager;
import cn.vika.client.api.model.PagerInfo;
import cn.vika.client.api.model.Record;
import cn.vika.client.api.model.Records;
import cn.vika.client.api.model.UpdateRecordRequest;
import cn.vika.core.http.GenericTypeReference;
import cn.vika.core.http.HttpHeader;
import cn.vika.core.utils.MapUtil;
import cn.vika.core.utils.StringUtil;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

public class RecordApi
extends AbstractApi {
    private static final String PATH = "/datasheets/%s/records";

    public RecordApi(ApiHttpClient apiHttpClient) {
        super(apiHttpClient);
    }

    public Stream<Record> getRecordsAsStream(String datasheetId) throws ApiException {
        return this.getRecords(datasheetId, this.getDefaultPerPage()).stream();
    }

    public List<Record> getRecords(String datasheetId, int page, int itemsPerPage) throws ApiException {
        if (page < 0 || itemsPerPage < 0) {
            throw new ApiException("page or itemsPerPage don't set right");
        }
        ApiQueryParam queryParam = new ApiQueryParam(page, itemsPerPage);
        Map<String, String> uriVariables = queryParam.toMap();
        GenericTypeReference<HttpResult<PagerInfo<Record>>> reference = new GenericTypeReference<HttpResult<PagerInfo<Record>>>(){};
        String uri = String.format(PATH, datasheetId) + MapUtil.extractKeyToVariables(uriVariables);
        HttpResult result = (HttpResult)this.getDefaultHttpClient().get(uri, new HttpHeader(), (GenericTypeReference)reference, uriVariables);
        return ((PagerInfo)result.getData()).getRecords();
    }

    public Pager<Record> getRecords(String datasheetId) throws ApiException {
        return new Pager<Record>((AbstractApi)this, String.format(PATH, datasheetId), this.getDefaultPerPage(), Record.class);
    }

    public Pager<Record> getRecords(String datasheetId, int itemsPerPage) throws ApiException {
        return new Pager<Record>((AbstractApi)this, String.format(PATH, datasheetId), itemsPerPage, Record.class);
    }

    public Pager<Record> getRecords(String datasheetId, ApiQueryParam queryParam) throws ApiException {
        return new Pager<Record>((AbstractApi)this, String.format(PATH, datasheetId), queryParam, Record.class);
    }

    public List<Record> addRecords(String datasheetId, CreateRecordRequest record) throws ApiException {
        if (!StringUtil.hasText((String)datasheetId)) {
            throw new ApiException("datasheet id must be not null");
        }
        if (record == null) {
            return null;
        }
        if (record.getRecords() == null) {
            return null;
        }
        if (record.getRecords().isEmpty()) {
            return null;
        }
        if (record.getRecords().size() > 10) {
            throw new ApiException("record only can add 10 every request");
        }
        HttpResult result = (HttpResult)this.getDefaultHttpClient().post(String.format(PATH, datasheetId), new HttpHeader(), (Object)record, (GenericTypeReference)new GenericTypeReference<HttpResult<Records>>(){}, new Object[0]);
        return ((Records)result.getData()).getRecords();
    }

    public List<Record> updateRecords(String datasheetId, UpdateRecordRequest record) throws ApiException {
        if (!StringUtil.hasText((String)datasheetId)) {
            throw new ApiException("datasheet id must be not null");
        }
        if (record == null) {
            throw new RuntimeException("Record instance cannot be null.");
        }
        HttpResult result = (HttpResult)this.getDefaultHttpClient().patch(String.format(PATH, datasheetId), new HttpHeader(), (Object)record, (GenericTypeReference)new GenericTypeReference<HttpResult<Records>>(){}, new Object[0]);
        return ((Records)result.getData()).getRecords();
    }

    public void deleteRecord(String datasheetId, String recordId) throws ApiException {
        this.deleteRecords(datasheetId, Collections.singletonList(recordId));
    }

    public void deleteRecords(String datasheetId, List<String> recordIds) throws ApiException {
        if (!StringUtil.hasText((String)datasheetId)) {
            throw new ApiException("datasheet id must be not null");
        }
        if (recordIds == null) {
            throw new ApiException("record id array must be not null");
        }
        if (recordIds.isEmpty()) {
            throw new ApiException("record id array must be not empty");
        }
        Map uriVariables = MapUtil.listToUriVariableMap((String)"recordIds", recordIds);
        String uri = String.format(PATH, datasheetId) + MapUtil.extractKeyToVariables((Map)uriVariables);
        this.getDefaultHttpClient().delete(uri, new HttpHeader(), Void.class, uriVariables);
    }
}

